% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{base58dec}
\alias{base58dec}
\title{Base58 Decode}
\usage{
base58dec(x, convert = TRUE)
}
\arguments{
\item{x}{a character string or raw vector containing base58 encoded data.}

\item{convert}{logical \code{TRUE} to convert back to a character string, \code{FALSE}
to convert back to a raw vector or \code{NA} to decode and then unserialize back
to the original object.}
}
\value{
A character string, raw vector, or other object depending on the
value of \code{convert}.
}
\description{
Decodes a character string or raw vector from base58 encoding with checksum.
}
\details{
The 4-byte checksum suffix is verified using double SHA-256 and an error is
raised if validation fails. Note: does not expect a version byte prefix
(unlike Bitcoin Base58Check).

The value of \code{convert} should be set to \code{TRUE}, \code{FALSE} or \code{NA} to be the
reverse of the 3 encoding operations (for strings, raw vectors and arbitrary
objects), in order to return the original object.
}
\examples{
base58dec(base58enc("secret base"))
base58dec(base58enc(as.raw(c(1L, 2L, 4L))), convert = FALSE)
base58dec(base58enc(data.frame()), convert = NA)

}
\references{
This implementation is based on 'libbase58' by Luke Dashjr under the MIT
licence at \url{https://github.com/luke-jr/libbase58}.
}
\seealso{
\code{\link[=base58enc]{base58enc()}}
}
