% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{divergence}
\alias{divergence}
\title{Compute the regularized divergence of topics}
\usage{
divergence(x, regularize = TRUE, min_size = 0.01, select = NULL)
}
\arguments{
\item{x}{a LDA model fitted by \code{\link[=textmodel_seededlda]{textmodel_seededlda()}} or \code{\link[=textmodel_lda]{textmodel_lda()}}.}

\item{regularize}{if \code{TRUE}, compute the regularized divergence.}

\item{min_size}{the minimum size of topics for regularized topic divergence.
Ignored when \code{regularize = FALSE}.}

\item{select}{names of topics for which the divergence is computed.}
}
\description{
Compute the regularized topic divergence to find the optimal
number of topics for LDA.
}
\details{
\code{divergence()} computes the average Jensen-Shannon divergence
between all the pairs of topic vectors in \code{x$phi}. The divergence score
maximizes when the chosen number of topic \code{k} is optimal (Deveaud et al.,
2014). The regularized divergence penalizes topics smaller than \code{min_size}
to avoid fragmentation (Watanabe & Baturo, forthcoming).
}
\references{
Deveaud, Romain et al. (2014). "Accurate and Effective Latent
Concept Modeling for Ad Hoc Information Retrieval".
doi:10.3166/DN.17.1.61-84. \emph{Document Numérique}.

Watanabe, Kohei & Baturo, Alexander. (forthcoming). "Seeded Sequential LDA:
A Semi-supervised Algorithm for Topic-specific Analysis of Sentences".
\emph{Social Science Computer Review}.
}
\seealso{
\link{sizes}
}
