% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_arrange.R
\name{multicurve}
\alias{multicurve}
\title{Merge multiple curves into a single graph}
\usage{
multicurve(
  plots,
  theme = theme_classic(),
  legend.title = NULL,
  legend.position = "top",
  trat = NA,
  gray = FALSE,
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  width.bar = NA,
  pointsize = 4.5,
  linesize = 0.8
)
}
\arguments{
\item{plots}{list with objects of type LM_model, BC_model, CD_model, LL_model or normal_model}

\item{theme}{ggplot2 theme (\emph{default} is theme_classi())}

\item{legend.title}{caption title}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{trat}{name of the curves}

\item{gray}{gray scale (\emph{default} is FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{width.bar}{bar width}

\item{pointsize}{shape size}

\item{linesize}{line size}
}
\value{
The function returns a graph joining the outputs of the functions LM_model, LL_model, BC_model, CD_model, loess_model, normal_model, piecewise_model and N_model
}
\description{
Merge multiple curves into a single graph
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
a=LM_model(trat,germ)
b=LL_model(trat,germ,npar = "LL.3")
c=BC_model(trat,germ, npar = "BC.4")
d=CD_model(trat,germ, npar = "CRS.4")
multicurve(list(a,b,c,d))
}
\author{
Gabriel Danilo Shimizu
}
