% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelClass.R
\name{setInput}
\alias{setInput}
\alias{setInput,odeModel-method}
\title{Set the inputs of the model.}
\usage{
setInput(odeModel, input)

\S4method{setInput}{odeModel}(odeModel, input)
}
\arguments{
\item{odeModel}{an object of the class modelClass}

\item{input}{function describing the ode equation of the model}
}
\value{
an object of odeModel
}
\description{
It the model has an input it can be set with this function. The inputs
should be a dataframe, where the first column is the timesteps of the
inputs in the second column.
}
\examples{

data("uvbModel")

model_times <- uvbModel@times
input <- rep(0,length(model_times))

input_Dataframe <- data.frame(t = model_times, u = input)

newModel <- setInput(odeModel = uvbModel,input = input_Dataframe)

}
