\name{ama}

\alias{ama}

\title{Amplitude modulation analysis of a time wave}

\description{
This function computes the Fourier analysis of a time wave envelope. This
allows to detect periodicity, in particular those generated by amplitude
modulations. 
}

\usage{
ama(wave, f, envt = "hil", wl = 512, plot = TRUE, type = "l", ...)
}

\arguments{
  \item{wave}{data describing the time wave
  or a \code{\link[sound]{Sample}} object generated loading a wav file
  with \code{\link[sound]{loadSample}} (package \pkg{sound}).}
  \item{f}{sampling frequency of \code{wave} (in Hz).
	Does not need to be specified if \code{wave} is a
	\code{\link[sound]{Sample}} object.}
  \item{envt}{the type of envelope to be used: either "abs" for absolute
    amplitude envelope or "hil" for Hilbert amplitude envelope.}
  \item{wl}{length of the window for the analysis (even number of points,
  by default = 512).}  
  \item{plot}{logical, if \code{TRUE} the spectrum of the envelope 
      (by default \code{TRUE}).}
  \item{type}{if \code{plot} is \code{TRUE}, type of plot that should be drawn.
      See \code{\link{plot}} for details (by default "l" for lines).}
  \item{\dots}{other \code{\link{meanspec}} parameters.}
}
\details{
This function is based on \code{env} and \code{meanspec}.\cr 
The envelope of \code{wave} is first computed and the spectrum of this envelope
is then processed. All \code{spec} and \code{meanspec} arguments can be
set up. Be sure to set up \code{wl} large enough if you want to detect low amplitude
modulation periodicity.
}

\value{
If \code{plot} is \code{FALSE}, \code{ama} returns  a vector of numeric
data corresponding to the computed spectrum.
If \code{peaks} is \code{TRUE}, \code{ama} returns a list with
two elements:
  \item{spec}{the spectrum computed}
  \item{peaks }{the peaks values (in kHz).}
}

\author{Jerome Sueur \email{sueur@mnhn.fr}}

\seealso{\code{\link{env}}}

\examples{
data(orni)
# detection of 2 main amplitude modulations in a cicada song:
# one with a 0.020 kHz frequency (due to signal/silence periodicity)
# one with a 0.258 kHz frequency (due to pulses in the echemes)
# one with a 2.369 kHz frequency (fundamental frequency)
ama(orni,f=22050,wl=1024)
# these amplitude modulations can be identify with a cursor:
ama(orni,f=22050,wl=1024,identify=TRUE)
}

\keyword{dplot}
\keyword{ts}
