\name{songmeter}

\alias{songmeter}

\title{Reading and interpreting SongMeter file name}

\description{This function reads and decomposes the files names generated by
SongMeters, audio digal recorders produced by the society Wildlife Acoustics.}

\usage{songmeter(x)}

\arguments{
  \item{x}{a character vector with file names, either \code{.wac} or
    \code{.wav}}
}

\details{The digital recorder SongMeter (either SM2 or SM3 device model)
  produced by the society 'Wildlife Acoustics' generates '.wav' or
  '.wac' files which names include useful information. Here are the
  character format of the files:\cr

\itemize{
    \item{\bold{SM2}: \code{PREFIX_YYYYMMDD_HHMMSS.wav}}
    \item{\bold{SM3}:
      \itemize{
	\item{\emph{without geolocalisation} \code{PREFIX_XXX_YYYYMMDD_HHMMSS.wav}}
	\item{\emph{with geolocalisation} \code{PREFIX_XXX_YYYYMMDD$HHMMSS.wav}}
      }
    }
  }

  with:
  \itemize{
    \item{\code{PREFIX}: prefix set when programming the SongMeter}
    \item{\code{XXX}: microphone information}
    \item{\code{YYYY}: year}
    \item{\code{MM}: month}
    \item{\code{DD}: day}
    \item{\code{HH}: hour}
    \item{\code{MM}: month}
    \item{\code{SS}: minute}
  }
  
  This information is read and decomposed by the function
  songmeter().\cr
  Please note that the function does not read the content of audio file
  but the name of the file.
}


\value{The function returns a \code{data.frame} with the following
  columns:
  \item{model}{device model, either "SM2" or "SM3"}
  \item{prefix}{prefix of the file, specifying for instance to
    recording site}
  \item{mic}{microphone information specifying if the recording is mono left channel ("monoL"),
  mono right ("monoR") or stereo ("stereo"). This works for SM3
  only, NA for SM2}
\item{year}{year of recording}
\item{month}{month of recording}
\item{day}{day of recording}
\item{hour}{hour of recording}
\item{min}{minute of recording}
\item{sec}{second of recording}
\item{time}{all time of recording information in \code{POSIX} format}
\item{geo}{logical, \code{TRUE} if the device was GPS synchronized}
}

\references{See Wildlife Acoustics website for details regarding the
  SongMeter 2 and 3: \url{http://www.wildlifeacoustics.com/}}

\author{Jerome Sueur}

\note{The file names of Songmeters may change with time. There is no
  guarantee that the function will be perfectly updated.}

\seealso{\code{\link{strptime}} for the POSIX time format.}

\examples{
file1 <- "MNHN_20141225_234500.wav"   ## SM2 file
file2 <- "CNRS_0+1_20130824_153000.wav"  # SM3 file without geolocalisation
file3 <- "PARIS_-0-_20150410$195550.wav"  # SM3 file with geolocalisation
file4 <- "MNHN_20141225_234500.txt" # not a .wav or a .wac file
file5 <- "myfile.wav"  # not a Wildlife Acoustics filename
files <- c(file1, file2, file3, file4, file5)
songmeter(files)
}

\keyword{input}
\keyword{data}
