% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_series_plot.R
\name{plot_segm}
\alias{plot_segm}
\title{Plot segmentation on time-serie}
\usage{
plot_segm(
  data,
  output,
  interactive = FALSE,
  diag.var,
  x_col = "expectTime",
  html = FALSE,
  order = FALSE,
  stationarity = FALSE
)
}
\arguments{
\item{data}{the data.frame with the different variable}

\item{output}{outputs of the segmentation  or segclust algorithm for one
number of segment}

\item{interactive}{should graph be interactive through leaflet ?}

\item{diag.var}{names of the variables on which statistics are calculated}

\item{x_col}{column name for time}

\item{html}{should the graph be incorporated in a markdown file through
htmltools::tagList()}

\item{order}{should cluster be ordered}

\item{stationarity}{if TRUE, cut each segment in three and plot each part
with its own mean to assess stationarity of each segment}
}
\value{
a graph
}
\description{
\code{plot_segm} plot segmented time serie.
}
\examples{
\dontrun{
#res.segclust is the results of the segmentation-clustering algorithm
ncluster = 3
nseg = 10
 g <- plot_segm(data = res.segclust$data, output =
  res.segclust$outputs[[paste(ncluster,"class -",nseg, "segments")]], 
   diag.var = x$`Diagnostic variables`,x_col = 'dateTime)
#res.seg is the results of the segmentation-only algorithm
nseg = 10
 g <- plot_segm(data = res.segclust$data, 
 output = res.segclust$outputs[[paste(nseg, "segments")]], 
  diag.var = x$`Diagnostic variables`,x_col = 'dateTime)
 
}
}
