% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{SeleniumSession}
\alias{SeleniumSession}
\title{Start a Selenium Client session}
\description{
This class represents the client to a Selenium session. It will only work
if a Selenium server instance is running. If you get an error, use
\code{\link[=selenium_server_available]{selenium_server_available()}} to check if a server is running. See the
package README for more information, or use \code{\link[=selenium_server]{selenium_server()}} to try and
start a server automatically.
}
\examples{

## ------------------------------------------------
## Method `SeleniumSession$new`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new(verbose = TRUE)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$create_webelement`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

element <- session$find_element(using = "css selector", value = "*")

element2 <- session$create_webelement(id = element$id)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$create_shadowroot`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

shadow_root <- session$create_shadowroot(id = "foo")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$close`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$status`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$status()

session$close()

session$status()
}

## ------------------------------------------------
## Method `SeleniumSession$get_timeouts`
## ------------------------------------------------

\dontrun{

session <- SeleniumSession$new()

session$get_timeouts()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$set_timeouts`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$set_timeouts(script = 100)

session$get_timeouts()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$navigate`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$current_url`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$current_url()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$back`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$navigate("https://www.tidyverse.org")

session$back()

session$current_url()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$forward`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$navigate("https://www.tidyverse.org")

session$back()

session$forward()

session$current_url()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$refresh`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$refresh()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$title`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$title()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$window_handle`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$window_handle()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$close_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$new_window()

session$close_window()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$switch_to_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

handle <- session$window_handle()

handle2 <- session$new_window()$handle

session$switch_to_window(handle)

session$switch_to_window(handle2)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$window_handles`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

handles <- session$window_handles()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$new_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

handle <- session$new_window()$handle

session$switch_to_window(handle)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$switch_to_frame`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$switch_to_frame()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$switch_to_parent_frame`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$switch_to_frame()

session$switch_to_parent_frame()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_window_rect`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$get_window_rect()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$set_window_rect`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$set_window_rect(width = 800, height = 600, x = 2, y = 3)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$maximize_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$maximize_window()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$minimize_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$minimize_window()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$fullscreen_window`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$fullscreen_window()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_active_element`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_active_element()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$find_element`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$find_element(using = "css selector", value = "#download")

session$find_element(using = "xpath", value = "//div[contains(@class, 'col-xs')]/h1")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$find_elements`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$find_elements(using = "css selector", value = "h1")

session$find_elements(using = "xpath", value = "//h1")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_page_source`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_page_source()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$execute_script`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_script("return 1")

session$execute_script("return arguments[0] + arguments[1]", 1, 2)

element <- session$find_element(value = "*")

session$execute_script("return arguments[0]", element)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$execute_async_script`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_async_script("
  let callback = arguments[arguments.length - 1];
  callback(1)
")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_cookies`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_cookies()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_cookie`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "foo", value = "bar"))

session$get_cookie("foo")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$add_cookie`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "my_cookie", value = "1"))

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$delete_cookie`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "foo", value = "bar"))

session$delete_cookie("foo")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$delete_all_cookies`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$delete_all_cookies()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$perform_actions`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

actions <- actions_stream(
  actions_press(keys$enter),
  actions_pause(0.5),
  actions_release(keys$enter)
)

session$perform_actions(actions)

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$release_actions`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

actions <- actions_stream(
  actions_press("a")
)

session$perform_actions(actions, release_actions = FALSE)

session$release_actions()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$dismiss_alert`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$dismiss_alert()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$accept_alert`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$accept_alert()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$get_alert_text`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$get_alert_text()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$send_alert_text`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$execute_script("prompt('Enter text:')")

session$send_alert_text("hello")

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$screenshot`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$screenshot()

session$close()
}

## ------------------------------------------------
## Method `SeleniumSession$print_page`
## ------------------------------------------------

\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$print_page()

session$close()
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{The id of the session, generated when the session is started.}

\item{\code{browser}}{The browser that the session is using.}

\item{\code{port}}{The port that the session is using.}

\item{\code{host}}{The host that the session is running on.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SeleniumSession-new}{\code{SeleniumSession$new()}}
\item \href{#method-SeleniumSession-create_webelement}{\code{SeleniumSession$create_webelement()}}
\item \href{#method-SeleniumSession-create_shadowroot}{\code{SeleniumSession$create_shadowroot()}}
\item \href{#method-SeleniumSession-close}{\code{SeleniumSession$close()}}
\item \href{#method-SeleniumSession-status}{\code{SeleniumSession$status()}}
\item \href{#method-SeleniumSession-get_timeouts}{\code{SeleniumSession$get_timeouts()}}
\item \href{#method-SeleniumSession-set_timeouts}{\code{SeleniumSession$set_timeouts()}}
\item \href{#method-SeleniumSession-navigate}{\code{SeleniumSession$navigate()}}
\item \href{#method-SeleniumSession-current_url}{\code{SeleniumSession$current_url()}}
\item \href{#method-SeleniumSession-back}{\code{SeleniumSession$back()}}
\item \href{#method-SeleniumSession-forward}{\code{SeleniumSession$forward()}}
\item \href{#method-SeleniumSession-refresh}{\code{SeleniumSession$refresh()}}
\item \href{#method-SeleniumSession-title}{\code{SeleniumSession$title()}}
\item \href{#method-SeleniumSession-window_handle}{\code{SeleniumSession$window_handle()}}
\item \href{#method-SeleniumSession-close_window}{\code{SeleniumSession$close_window()}}
\item \href{#method-SeleniumSession-switch_to_window}{\code{SeleniumSession$switch_to_window()}}
\item \href{#method-SeleniumSession-window_handles}{\code{SeleniumSession$window_handles()}}
\item \href{#method-SeleniumSession-new_window}{\code{SeleniumSession$new_window()}}
\item \href{#method-SeleniumSession-switch_to_frame}{\code{SeleniumSession$switch_to_frame()}}
\item \href{#method-SeleniumSession-switch_to_parent_frame}{\code{SeleniumSession$switch_to_parent_frame()}}
\item \href{#method-SeleniumSession-get_window_rect}{\code{SeleniumSession$get_window_rect()}}
\item \href{#method-SeleniumSession-set_window_rect}{\code{SeleniumSession$set_window_rect()}}
\item \href{#method-SeleniumSession-maximize_window}{\code{SeleniumSession$maximize_window()}}
\item \href{#method-SeleniumSession-minimize_window}{\code{SeleniumSession$minimize_window()}}
\item \href{#method-SeleniumSession-fullscreen_window}{\code{SeleniumSession$fullscreen_window()}}
\item \href{#method-SeleniumSession-get_active_element}{\code{SeleniumSession$get_active_element()}}
\item \href{#method-SeleniumSession-find_element}{\code{SeleniumSession$find_element()}}
\item \href{#method-SeleniumSession-find_elements}{\code{SeleniumSession$find_elements()}}
\item \href{#method-SeleniumSession-get_page_source}{\code{SeleniumSession$get_page_source()}}
\item \href{#method-SeleniumSession-execute_script}{\code{SeleniumSession$execute_script()}}
\item \href{#method-SeleniumSession-execute_async_script}{\code{SeleniumSession$execute_async_script()}}
\item \href{#method-SeleniumSession-get_cookies}{\code{SeleniumSession$get_cookies()}}
\item \href{#method-SeleniumSession-get_cookie}{\code{SeleniumSession$get_cookie()}}
\item \href{#method-SeleniumSession-add_cookie}{\code{SeleniumSession$add_cookie()}}
\item \href{#method-SeleniumSession-delete_cookie}{\code{SeleniumSession$delete_cookie()}}
\item \href{#method-SeleniumSession-delete_all_cookies}{\code{SeleniumSession$delete_all_cookies()}}
\item \href{#method-SeleniumSession-perform_actions}{\code{SeleniumSession$perform_actions()}}
\item \href{#method-SeleniumSession-release_actions}{\code{SeleniumSession$release_actions()}}
\item \href{#method-SeleniumSession-dismiss_alert}{\code{SeleniumSession$dismiss_alert()}}
\item \href{#method-SeleniumSession-accept_alert}{\code{SeleniumSession$accept_alert()}}
\item \href{#method-SeleniumSession-get_alert_text}{\code{SeleniumSession$get_alert_text()}}
\item \href{#method-SeleniumSession-send_alert_text}{\code{SeleniumSession$send_alert_text()}}
\item \href{#method-SeleniumSession-screenshot}{\code{SeleniumSession$screenshot()}}
\item \href{#method-SeleniumSession-print_page}{\code{SeleniumSession$print_page()}}
\item \href{#method-SeleniumSession-clone}{\code{SeleniumSession$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-new"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-new}{}}}
\subsection{Method \code{new()}}{
Create a Selenium session: opening a browser which can be controlled by
the Selenium client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$new(
  browser = "firefox",
  port = 4444L,
  host = "localhost",
  verbose = FALSE,
  capabilities = NULL,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{browser}}{The name of the browser to use (e.g. "chrome", "firefox",
"edge").}

\item{\code{port}}{The port that the Selenium server is using, so we can
connect to it.}

\item{\code{host}}{The host that the Selenium server is running on. This is
usually 'localhost' (i.e. your own machine).}

\item{\code{verbose}}{Whether to print the web requests that are being sent and
any responses.}

\item{\code{capabilities}}{A list of capabilities to pass to the Selenium
server, to combine with the defaults generated using \code{browser}.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server. Overrides \code{capabilities}.}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{SeleniumSession} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new(verbose = TRUE)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-create_webelement"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-create_webelement}{}}}
\subsection{Method \code{create_webelement()}}{
Create a \link{WebElement} object using the parameters of the current
session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$create_webelement(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The element id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{WebElement} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

element <- session$find_element(using = "css selector", value = "*")

element2 <- session$create_webelement(id = element$id)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-create_shadowroot"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-create_shadowroot}{}}}
\subsection{Method \code{create_shadowroot()}}{
Create a \link{ShadowRoot} object using the parameters of the current
session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$create_shadowroot(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The shadow root id.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{ShadowRoot} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

shadow_root <- session$create_shadowroot(id = "foo")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-close"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-close}{}}}
\subsection{Method \code{close()}}{
Close the current session. Once a session is closed, its methods will
no longer work. However, the Selenium server will still be running.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$close(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-status"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-status}{}}}
\subsection{Method \code{status()}}{
Get the status of the Selenium server. Unlike all other methods, this
method is independent of the session itself (meaning it can be used
even after \link[=SeleniumSession]{SeleniumSession$close()} is called). It is
identical to \code{\link[=get_server_status]{get_server_status()}}, but uses the host, port and verbose
options passed to the session, for convenience.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$status(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list that can (but may not always) contain the following
fields:
\itemize{
\item \code{ready}: Whether the server is ready to be connected to. This should
always be returned by the server.
\item \code{message}: A message about the status of the server.
\item \code{uptime}: How long the server has been running.
\item \code{nodes}: Information about the slots that the server can take.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$status()

session$close()

session$status()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_timeouts"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_timeouts}{}}}
\subsection{Method \code{get_timeouts()}}{
Get the timeouts of the current session. There are three types of
timeouts:
\itemize{
\item \emph{session script timeout}: The amount of time that the server will wait
for scripts to run. Defaults to 3 seconds.
\item \emph{page load timeout}: The amount of time that the server will wait for
the page to load. Defaults to 30 seconds.
\item \emph{implicit wait}: The amount of time that the server will wait for
elements to be located, or for elements to become interactable when
required. Defaults to 0 seconds.
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_timeouts(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with three items: \code{script}, \code{page_load}, and \code{implicit}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{

session <- SeleniumSession$new()

session$get_timeouts()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-set_timeouts"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-set_timeouts}{}}}
\subsection{Method \code{set_timeouts()}}{
Set the timeouts of the current session. The types of timeouts are
defined in \code{SeleniumSession$get_timeouts()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$set_timeouts(
  script = NULL,
  page_load = NULL,
  implicit_wait = NULL,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{script}}{The amount of time to wait for scripts. By default, this
is not set.}

\item{\code{page_load}}{The amount of time to wait for the page to load.}

\item{\code{implicit_wait}}{The amount of time to wait for elements on the
page.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$set_timeouts(script = 100)

session$get_timeouts()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-navigate"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-navigate}{}}}
\subsection{Method \code{navigate()}}{
Navigate to a URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$navigate(url, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to navigate to. Must begin with a protocol (e.g.
'https://').}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request.}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-current_url"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-current_url}{}}}
\subsection{Method \code{current_url()}}{
Get the current URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$current_url(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URL of the current page.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$current_url()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-back"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-back}{}}}
\subsection{Method \code{back()}}{
Go back in the navigation history.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$back(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$navigate("https://www.tidyverse.org")

session$back()

session$current_url()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-forward"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-forward}{}}}
\subsection{Method \code{forward()}}{
Go forward in the navigation history.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$forward(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$navigate("https://www.tidyverse.org")

session$back()

session$forward()

session$current_url()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-refresh}{}}}
\subsection{Method \code{refresh()}}{
Reload the current page.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$refresh(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$refresh()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-title"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-title}{}}}
\subsection{Method \code{title()}}{
Get the title of the current page.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$title(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The title of the current page.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$title()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-window_handle"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-window_handle}{}}}
\subsection{Method \code{window_handle()}}{
Get the current window handle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$window_handle(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The handle of the current window (a string).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$window_handle()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-close_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-close_window}{}}}
\subsection{Method \code{close_window()}}{
Close the current window.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$close_window(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$new_window()

session$close_window()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-switch_to_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-switch_to_window}{}}}
\subsection{Method \code{switch_to_window()}}{
Switch to a specific window.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$switch_to_window(handle, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{The handle of the window to switch to.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

handle <- session$window_handle()

handle2 <- session$new_window()$handle

session$switch_to_window(handle)

session$switch_to_window(handle2)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-window_handles"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-window_handles}{}}}
\subsection{Method \code{window_handles()}}{
Get the handles of all open windows.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$window_handles(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The handles of all open windows (a list of strings).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

handles <- session$window_handles()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-new_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-new_window}{}}}
\subsection{Method \code{new_window()}}{
Create a new window. Note that this window is not automatically
switched to.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$new_window(
  type = c("tab", "window"),
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Whether to create a tab or a window.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing two elements:
\itemize{
\item \code{handle}: The handle of the new window.
\item \code{type}: The type of window. ("tab" or "window").
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

handle <- session$new_window()$handle

session$switch_to_window(handle)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-switch_to_frame"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-switch_to_frame}{}}}
\subsection{Method \code{switch_to_frame()}}{
Frames allow you to split a window into multiple sections, where each
section can load a separate HTML document. This function allows you to
switch to a specific frame, given its ID, meaning that frame will become
the current browsing context.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$switch_to_frame(id = NA, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the frame to switch to. By default, the top-level
browsing context is switched to (i.e. not a frame). This can also be
a \link{WebElement} object, in which case the frame that contains said
element will be switched to.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$switch_to_frame()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-switch_to_parent_frame"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-switch_to_parent_frame}{}}}
\subsection{Method \code{switch_to_parent_frame()}}{
Switch to the parent frame of the current frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$switch_to_parent_frame(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$switch_to_frame()

session$switch_to_parent_frame()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_window_rect"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_window_rect}{}}}
\subsection{Method \code{get_window_rect()}}{
Get the size and position of the current window.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_window_rect(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing four elements:
\itemize{
\item \code{x}: The x position of the window relative to the left of the screen.
\item \code{y}: The y position of the window relative to the top of the screen.
\item \code{width}: The width of the window.
\item \code{height}: The height of the window.
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$get_window_rect()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-set_window_rect"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-set_window_rect}{}}}
\subsection{Method \code{set_window_rect()}}{
Set the size and position of the current window.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$set_window_rect(
  width = NULL,
  height = NULL,
  x = NULL,
  y = NULL,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{The width of the window.}

\item{\code{height}}{The height of the window.}

\item{\code{x}}{The x position of the window relative to the left of the screen.}

\item{\code{y}}{The y position of the window relative to the top of the screen.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$set_window_rect(width = 800, height = 600, x = 2, y = 3)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-maximize_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-maximize_window}{}}}
\subsection{Method \code{maximize_window()}}{
Maximize the current window. This makes the window the maximum size it
can be, without being full screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$maximize_window(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$maximize_window()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-minimize_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-minimize_window}{}}}
\subsection{Method \code{minimize_window()}}{
Minimize the current window. This hides the window.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$minimize_window(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$minimize_window()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-fullscreen_window"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-fullscreen_window}{}}}
\subsection{Method \code{fullscreen_window()}}{
Make the window full screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$fullscreen_window(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$fullscreen_window()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_active_element"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_active_element}{}}}
\subsection{Method \code{get_active_element()}}{
Get the currently active element.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_active_element(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{WebElement} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_active_element()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-find_element"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-find_element}{}}}
\subsection{Method \code{find_element()}}{
Find the first element matching a selector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$find_element(
  using = c("css selector", "xpath", "tag name", "link text", "partial link text"),
  value,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{using}}{The type of selector to use.}

\item{\code{value}}{The value of the selector: a string.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \link{WebElement} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$find_element(using = "css selector", value = "#download")

session$find_element(using = "xpath", value = "//div[contains(@class, 'col-xs')]/h1")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-find_elements"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-find_elements}{}}}
\subsection{Method \code{find_elements()}}{
Find all elements matching a selector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$find_elements(
  using = c("css selector", "xpath", "tag name", "link text", "partial link text"),
  value,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{using}}{The type of selector to use.}

\item{\code{value}}{The value of the selector: a string.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of \link{WebElement} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$find_elements(using = "css selector", value = "h1")

session$find_elements(using = "xpath", value = "//h1")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_page_source"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_page_source}{}}}
\subsection{Method \code{get_page_source()}}{
Get the HTML source of the current page, serialized as a string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_page_source(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_page_source()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-execute_script"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-execute_script}{}}}
\subsection{Method \code{execute_script()}}{
Execute a JavaScript script.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$execute_script(x, ..., request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The script to execute. To return a value, do so explicitly,
e.g. \verb{return 1}.}

\item{\code{...}}{Additional arguments to pass to the script. These can be
accessed in the script using the \code{arguments} array. Can be \link{WebElement}
objects or lists of such objects, which will be converted to nodes.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The return value of the script. Nodes or lists of nodes will
be converted to \link{WebElement} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_script("return 1")

session$execute_script("return arguments[0] + arguments[1]", 1, 2)

element <- session$find_element(value = "*")

session$execute_script("return arguments[0]", element)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-execute_async_script"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-execute_async_script}{}}}
\subsection{Method \code{execute_async_script()}}{
Execute an asynchronous JavaScript script, waiting for a value to be
returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$execute_async_script(x, ..., request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{The script to execute. Unlike \code{execute_script()}. You return
an value using the callback function, which can be accessed using
\code{arguments[arguments.length - 1]}. For example, to return 1, you
would write \code{arguments[arguments.length - 1](1)}. This allows you to
write asynchronous JavaScript, but treat it like synchronous R code.}

\item{\code{...}}{Additional arguments to pass to the script. Can be
\link{WebElement} objects or lists of such objects, which will be converted
to nodes.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The return value of the script. Nodes or lists of nodes will
be converted to \link{WebElement} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_async_script("
  let callback = arguments[arguments.length - 1];
  callback(1)
")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_cookies"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_cookies}{}}}
\subsection{Method \code{get_cookies()}}{
Get all cookies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_cookies(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of cookies. Each cookie is a list with a \code{name} and
\code{value} field, along with some other optional fields.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$get_cookies()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_cookie"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_cookie}{}}}
\subsection{Method \code{get_cookie()}}{
Get a specific cookie using its name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_cookie(name, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the cookie.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cookie object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "foo", value = "bar"))

session$get_cookie("foo")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-add_cookie"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-add_cookie}{}}}
\subsection{Method \code{add_cookie()}}{
Add a cookie to the cookie store of the current document.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$add_cookie(cookie, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cookie}}{The cookie object to add: a list which must contain a
\code{name} and \code{value} field.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "my_cookie", value = "1"))

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-delete_cookie"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-delete_cookie}{}}}
\subsection{Method \code{delete_cookie()}}{
Delete a cookie using its name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$delete_cookie(name, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the cookie.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$add_cookie(list(name = "foo", value = "bar"))

session$delete_cookie("foo")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-delete_all_cookies"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-delete_all_cookies}{}}}
\subsection{Method \code{delete_all_cookies()}}{
Delete all cookies in the cookie store of the current document.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$delete_all_cookies(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$delete_all_cookies()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-perform_actions"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-perform_actions}{}}}
\subsection{Method \code{perform_actions()}}{
Perform a sequence of actions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$perform_actions(
  actions,
  release_actions = TRUE,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{actions}}{A \code{selenium_actions_stream} object, created using
\code{\link[=actions_stream]{actions_stream()}}.}

\item{\code{release_actions}}{Whether to call \code{release_actions()} after
performing the actions.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

actions <- actions_stream(
  actions_press(keys$enter),
  actions_pause(0.5),
  actions_release(keys$enter)
)

session$perform_actions(actions)

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-release_actions"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-release_actions}{}}}
\subsection{Method \code{release_actions()}}{
Release all keys and pointers that were pressed using
\code{perform_actions()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$release_actions(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

actions <- actions_stream(
  actions_press("a")
)

session$perform_actions(actions, release_actions = FALSE)

session$release_actions()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-dismiss_alert"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-dismiss_alert}{}}}
\subsection{Method \code{dismiss_alert()}}{
Dismiss the current alert, if present.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$dismiss_alert(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$dismiss_alert()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-accept_alert"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-accept_alert}{}}}
\subsection{Method \code{accept_alert()}}{
Accept the current alert, if present.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$accept_alert(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$accept_alert()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-get_alert_text"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-get_alert_text}{}}}
\subsection{Method \code{get_alert_text()}}{
Get the message of the current alert, if present.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$get_alert_text(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The message of the current alert (a string).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_script("alert('hello')")

session$get_alert_text()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-send_alert_text"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-send_alert_text}{}}}
\subsection{Method \code{send_alert_text()}}{
Send text to the current alert, if present. Useful if the alert is a
prompt.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$send_alert_text(text, request_body = NULL, timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{The text to send.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The session object, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$execute_script("prompt('Enter text:')")

session$send_alert_text("hello")

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-screenshot"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-screenshot}{}}}
\subsection{Method \code{screenshot()}}{
Take a screenshot of the current page.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$screenshot(timeout = 20)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The base64-encoded PNG screenshot, as a string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$screenshot()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-print_page"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-print_page}{}}}
\subsection{Method \code{print_page()}}{
Render the current page as a PDF.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$print_page(
  orientation = c("portrait", "landscape"),
  scale = 1,
  background = FALSE,
  width = NULL,
  height = NULL,
  margin = NULL,
  footer = NULL,
  header = NULL,
  shrink_to_fit = NULL,
  page_ranges = NULL,
  request_body = NULL,
  timeout = 20
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orientation}}{The page orientation, either \code{"portrait"} or
\code{"landscape"}.}

\item{\code{scale}}{The page scale, a number between 0.1 and 2.}

\item{\code{background}}{Whether to print the background of the page.}

\item{\code{width}}{The page width, in inches.}

\item{\code{height}}{The page height, in inches.}

\item{\code{margin}}{The page margin, in inches. Either a number, in which case
the margin on all sides are set to that value, or a list of four
numbers, with names \code{left}, \code{right}, \code{top}, and \code{bottom}, in which
case the margin on each side is set individually.}

\item{\code{footer}}{The page footer, as a string.}

\item{\code{header}}{The page header, as a string.}

\item{\code{shrink_to_fit}}{Whether to shrink the page to fit the width and
height.}

\item{\code{page_ranges}}{A list of page ranges (e.g. \code{"1"}, \code{"1-3"}) to print.}

\item{\code{request_body}}{A list of request body parameters to pass to the
Selenium server, overriding the default body of the web request}

\item{\code{timeout}}{How long to wait for a request to recieve a response
before throwing an error.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The base64-encoded PDF, as a string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
session <- SeleniumSession$new()

session$navigate("https://www.r-project.org")

session$print_page()

session$close()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SeleniumSession-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SeleniumSession-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SeleniumSession$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
