% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cookies.R, R/cookiesDoc.R
\name{getNamedCookie}
\alias{getNamedCookie}
\title{Get a named cookie}
\usage{
getNamedCookie(remDr, name = NULL, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{name}{character: The name of the cookie; may not be null or an empty string}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
A named cookies from the current domain is returned if it exists. These cookies
have values as stipulated by the arguments given in \code{\link{addCookie}}.
}
\description{
\code{getNamedCookie} Get the cookie with a given name.
}
\examples{
\dontrun{
# assume a server is running at default location
remDr <- remoteDr()
remDr \%>\% go("https://www.google.com/ncr") \%>\%
  getTitle()
# get the cookies
remDr \%>\% getCookie()
# get a named cookie
remDr \%>\% getCookie("NID")
# add our own cookie
remDr \%>\% addCookie(name = "myCookie", value = "12")
# check its value
remDr \%>\% getCookie("myCookie")
# delete our cookie
remDr \%>\% deleteCookie("myCookie")
# check its deleted
remDr \%>\% getCookie("myCookie")

# delete all cookies
remDr \%>\% getCookie()
remDr \%>\% deleteAllCookies() \%>\%
  getCookie()

remDr \%>\% deleteSession()
}
}
\seealso{
Other cookies functions: \code{\link{addCookie}},
  \code{\link{deleteAllCookies}},
  \code{\link{deleteCookie}}, \code{\link{getAllCookies}}
}

