% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R, R/navigationDoc.R
\name{back}
\alias{back}
\title{Navigate backwards}
\usage{
back(remDr, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
invisible(remDr): An object of class "rDriver" is invisibly returned.
   A remote driver object see \code{\link{remoteDr}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{back} Navigate backwards in the browser history, if possible.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # get the title
  remDr \%>\% getTitle

  # get the current page url
  remDr \%>\% getCurrentUrl

  # navigate
  remDr \%>\% go("http://www.bbc.co.uk")

  # go back
  remDr \%>\% (seleniumPipes::back)

  # go forward
  remDr \%>\% forward

  # refresh page
  remDr \%>\% refresh

  # close browser
  remDr \%>\% deleteSession
}

}
\seealso{
Other navigation functions: \code{\link{forward}},
  \code{\link{getCurrentUrl}}, \code{\link{getTitle}},
  \code{\link{go}}, \code{\link{refresh}}
}

