% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{interactions}
\alias{interactions}
\title{Interaction Functions}
\usage{
interactions(...)
}
\arguments{
\item{...}{Interaction Combinations as generated by the \code{interaction_scaled} or
\code{interaction_ortho} methods.}
}
\description{
\code{interactions} creates interaction measurement items by multipying all combination of construct items.
}
\details{
This function automatically generates interaction measurement items for a PLS SEM.
}
\examples{
data(mobi)

# seminr syntax for creating measurement model
mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2)),
  composite("Satisfaction", multi_items("CUSA", 1:3))
)
mobi_xm <- interactions(
  interaction_ortho("Image", "Expectation"),
  interaction_ortho("Image", "Value")
)

#  structural model: note that name of the interactions construct should be
#  the names of its two main constructs joined by a '.' in between.
mobi_sm <- relationships(
  paths(to = "Satisfaction",
        from = c("Image", "Expectation", "Value",
                 "Image.Expectation", "Image.Value"))
)

mobi_pls <- estimate_pls(mobi, mobi_mm, mobi_xm, mobi_sm)
summary(mobi_pls)

}
