% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_effects.R
\name{fSquared}
\alias{fSquared}
\title{seminr fSquared Function}
\usage{
fSquared(seminr_model, iv, dv)
}
\arguments{
\item{seminr_model}{A \code{seminr_model} containing the estimated seminr model.}

\item{iv}{An independent variable in the model.}

\item{dv}{A dependent variable in the model.}
}
\description{
The \code{fSquared} function calculates f^2 effect size for a given IV and DV
}
\examples{
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )

mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                         measurement_model = mobi_mm,
                         structural_model = mobi_sm)

fSquared(mobi_pls, "Image", "Satisfaction")
}
\references{
Cohen, J. (2013). Statistical power analysis for the behavioral sciences. Routledge.
}
