\name{plot.semsfa}
\alias{plot.semsfa}
%\alias{plot}
\title{Default SEMSFA plotting}
\description{
This function plots the semiparametric/nonparametric intermediate model object estimated in the first step of the algorithm and, if \code{efficiencies.semsfa()} is esecuted, individual point estimate of the efficiency.
}
\usage{
\method{plot}{semsfa}(x, g.type, mod, ...)
}
\arguments{
  \item{x}{
a \code{semsfa} object as returned from \code{semsfa()} or \code{efficiencies.semsfa()}
}
  \item{g.type}{
a character string indicating the type of plot. Possible values are: "reg" to plot the semiparametric/nonparametric model object estimated in the first step from \code{semsfa()}, "eff" to draw point estimate of the efficiency obtained from \code{efficiencies.semsfa()}
}
  \item{mod}{
a character string indicating the plot style for g.type="eff": "hist" for histogram and "dens" for density plot
}
  \item{\dots}{
further arguments passed to plot.default.
}
}

\value{
The function simply generates plots. 
}

\author{
Giancarlo Ferrara and Francesco Vidoli
}

\seealso{
\code{\link{semsfa}}, \code{\link{efficiencies.semsfa}}.
}
\examples{
set.seed(0)
n<-200

#generate data
x<- runif(n, 1, 2)
fy<- 2+30*x-5*x^2
v<- rnorm(n, 0, 1)
u<- abs(rnorm(n,0,2.5))
#production frontier
y <- fy + v - u
dati<-data.frame(y,x)

#first-step: gam, second-step: fan (default)
o<-semsfa(y~s(x),dati,sem.method="gam")
#the following plot will be like that generated by plot.gam
plot(o,g.type="reg")

#adding a covariate
z<- runif(n, 1, 2)
dati$z<-z

#first-step: kernel, second-step: fan (default)
o<-semsfa(y~x+z,dati,sem.method="kernel")
#the plot will be like that generated by a plot.npreg
\dontrun{plot(o,g.type="reg")}

#calculate efficiencies ...
a<-efficiencies.semsfa(o)
plot(a,g.type="eff",mod="dens")

#adding further parameters as for plot.default: col, main, xlim, ...
plot(a,g.type="eff",mod="dens",col=2,main="Density Efficiency",xlim=c(0,1),xlab="Efficiency")
}