% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semforest.R
\name{semforest}
\alias{semforest}
\alias{print.semforest}
\alias{plot.semforest}
\title{Create a SEM Forest}
\usage{
semforest(
  model,
  data,
  control = NULL,
  predictors = NULL,
  constraints = NULL,
  cluster = NULL,
  ...
)
}
\arguments{
\item{model}{A template SEM. Same as in \code{semtree}.}

\item{data}{A dataframe to create a forest from. Same as in \code{semtree}.}

\item{control}{A semforest control object to set forest parameters.}

\item{predictors}{An optional list of covariates. See semtree code example.}

\item{constraints}{An optional list of covariates. See semtree code example.}

\item{cluster}{An object of class "cluster" representing a parallel socket
cluster. See package \link[parallel]{makeCluster}.}

\item{\dots}{Optional parameters.}
}
\value{
A semforest object.
}
\description{
Grows a SEM Forest from a template model and a dataset. This may take some
time.
}
\references{
Brandmaier, A.M., Prindle, J. J., McArdle, J. J., &
Lindenberger, U. (2016). Theory-guided exploration with structural equation
model forests. \emph{Psychological Methods}, 21(4), 566--582.

Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger, U. (2013).
Structural equation model trees. \emph{Psychological Methods}, 18(1),
71--86.
}
\seealso{
\code{\link{semtree}}
}
\author{
Andreas M. Brandmaier, John J. Prindle
}
\keyword{models}
\keyword{multivariate}
\keyword{tree}
