% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partialDependence.R
\name{partialDependence_growth}
\alias{partialDependence_growth}
\title{Compute partial dependence for latent growth models}
\usage{
partialDependence_growth(
  x,
  data,
  reference.var,
  support = 20,
  points = NULL,
  mc = NULL,
  FUN = "median",
  times = NULL,
  parameters = NULL,
  ...
)
}
\arguments{
\item{x}{An object for which a method exists}

\item{data}{Optional \code{data.frame} that was used to train the
model.}

\item{reference.var}{Character vector, referring to the (independent)
reference variable or variables for which partial dependence is calculated.
Providing two (or more) variables allows for probing interactions, but note
that this is computationally expensive.}

\item{support}{Integer. Number of grid points for interpolating the
\code{reference.var}. Alternatively, use \code{points} for one or more
variables named in \code{reference.var}.}

\item{points}{Named list, with elements corresponding to \code{reference.var}
. Use this argument to provide specific points for which to obtain marginal
dependence values; for example, the mean and +/- 1SD of \code{reference.var}.}

\item{mc}{Integer. If \code{mc} is not \code{NULL}, the function will sample
\code{mc} number of rows from \code{data} with replacement, to estimate 
marginal dependency using Monte Carlo integration. This is less
computationally expensive.}

\item{FUN}{Character string with function used to integrate predictions
across all elements of \code{x}.}

\item{times}{Numeric matrix, representing the factor loadings of a latent
growth model, with columns equal to the number of growth \code{parameters},
and rows equal to the number of measurement occasions.}

\item{parameters}{Character vector of the names of the growth parameters;
defaults to \code{NULL}, which assumes that the growth parameters are the
only parameters and are in the correct order.}

\item{...}{Extra arguments passed to \code{FUN}.}
}
\description{
Compute the partial dependence of a predictor, or set of predictors,
on the predicted trajectory of a latent growth model.
}
\author{
Caspar J. Van Lissa
}
