% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn}
\alias{nn}
\title{Replace NULL with character()}
\usage{
nn(x)
}
\arguments{
\item{x}{Input variable}
}
\value{
\code{character(0)} if \code{x==NULL}, \code{x} elsewhere
}
\description{
Internal function: return character(0) instead of NULL.
This is sometimes needed not to return error when applying some functions.
}
\note{
License: GPL 3.0
}
\examples{
tryCatch(basename(NULL), error = print) # error
basename(character()) # ok
basename(sen2r:::nn(NULL)) # ok
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
