% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{list_lexicons}
\alias{list_lexicons}
\title{Built-in lexicons}
\format{A \code{list} with all built-in lexicons, appropriately named as \code{"NAME_language(_tr)"} .}
\source{
\href{http://www.lirmm.fr/~abdaoui/FEEL}{FEEL lexicon}

\href{http://www.wjh.harvard.edu/~inquirer/spreadsheet_guide.htm}{GI lexicon}

\href{https://study.sagepub.com/sites/default/files/1\%20Henry\%202008_0.pdf}{HENRY lexicon}

\href{https://www3.nd.edu/~mcdonald/Word_Lists.html}{LM lexicon}
}
\usage{
data("list_lexicons")
}
\description{
A \code{list} containing all built-in lexicons as a \code{data.table} with two columns: a \code{x} column with the words,
and a \code{y} column with the polarities. The \code{list} element names incorporate consecutively the name and language
(based on the two-letter ISO code convention as in \code{\link[stopwords]{stopwords}}), and \code{"_tr"} as
suffix if the lexicon is translated. The translation was done via Microsoft Translator through Microsoft
Word. Only the entries that conform to the original language entry after retranslation, and those that have actually been
translated, are kept. The last condition is assumed to be fulfilled when the translation differs from the original entry.
All words are in lowercase. The lexicons are in the format required for further sentiment analysis. The built-in lexicons
are the following:

\itemize{
  \item FEEL_en_tr (French Expanded Emotion Lexicon)
  \item FEEL_fr
  \item FEEL_nl_tr
  \item GI_en (General Inquirer, i.e. Harvard IV-4 combined with Laswell)
  \item GI_fr_tr
  \item GI_nl_tr
  \item HENRY_en (Henry)
  \item HENRY_fr_tr
  \item HENRY_nl_tr
  \item LM_en (Loughran and McDonald)
  \item LM_fr_tr
  \item LM_nl_tr
}

Other immediate lexicon options can be found in the \pkg{lexicon} package, more specifically the datasets preceded by
\code{hash_sentiment_}.
}
\examples{
data("list_lexicons", package = "sentometrics")
list_lexicons[c("FEEL_en_tr", "LM_en")]

}
\keyword{datasets}
