% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_engines.R
\name{sentiment_bind}
\alias{sentiment_bind}
\title{Bind sentiment objects row-wise}
\usage{
sentiment_bind(...)
}
\arguments{
\item{...}{\code{sentiment} objects to combine in the order given.}
}
\value{
A new, larger, \code{sentiment} object.
}
\description{
Combines multiple sentiment objects with the same column names into a new sentiment object. Duplicates
in terms of document identifiers across input objects are removed.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")])

corp1 <- sento_corpus(corpusdf = usnews[1:200, ])
corp2 <- sento_corpus(corpusdf = usnews[201:450, ])
corp3 <- sento_corpus(corpusdf = usnews[401:700, ])

sent1 <- compute_sentiment(corp1, l, how = "proportionalPol")
sent2 <- compute_sentiment(corp2, l, how = "counts")
sent3 <- compute_sentiment(corp3, l, how = "proportional")

sent <- sentiment_bind(sent1, sent2, sent3)
nrow(sent) # 700

}
\author{
Samuel Borms
}
