library('seplyr')

context("basictest")

test_that("test_basic.R", {
  if(!requireNamespace('datasets', quietly = TRUE)) {
    return(invisible(NULL))
  }

  groupingCols <- c("cyl", "gear")
  r1 <- datasets::mtcars %.>%
    group_summarize(.,
                    groupingCols,
                    group_mean_mpg = mean(mpg),
                    group_mean_disp = mean(disp)) %.>%
    arrange_se(., groupingCols) %.>%
    as.data.frame(.)

  r2 <- wrapr::build_frame(
    "cyl"  , "gear", "group_mean_mpg", "group_mean_disp" |
      4    , 3     , 21.5            , 120.1             |
      4    , 4     , 26.93           , 102.6             |
      4    , 5     , 28.2            , 107.7             |
      6    , 3     , 19.75           , 241.5             |
      6    , 4     , 19.75           , 163.8             |
      6    , 5     , 19.7            , 145               |
      8    , 3     , 15.05           , 357.6             |
      8    , 5     , 15.4            , 326               )

  testthat::expect_equal(r1, r2, tolerance = 0.01)


  r1 <- datasets::mtcars %.>%
    group_mutate(.,
                 c("cyl", "gear"),
                 rank = dplyr::row_number(),
                 arrangeTerms = "-disp") %.>%
    arrange_se(.,
               wrapr::qc(mpg, cyl, disp, hp, drat, wt, qsec, vs, am, gear, carb, rank)) %.>%
    as.data.frame(.)

  r2 <- wrapr::build_frame(
    "mpg"  , "cyl", "disp", "hp", "drat", "wt" , "qsec", "vs", "am", "gear", "carb", "rank" |
      10.4 , 8    , 460   , 215 , 3     , 5.424, 17.82 , 0   , 0   , 3     , 4     ,  2L    |
      10.4 , 8    , 472   , 205 , 2.93  , 5.25 , 17.98 , 0   , 0   , 3     , 4     ,  1L    |
      13.3 , 8    , 350   , 245 , 3.73  , 3.84 , 15.41 , 0   , 0   , 3     , 4     ,  7L    |
      14.3 , 8    , 360   , 245 , 3.21  , 3.57 , 15.84 , 0   , 0   , 3     , 4     ,  6L    |
      14.7 , 8    , 440   , 230 , 3.23  , 5.345, 17.42 , 0   , 0   , 3     , 4     ,  3L    |
      15   , 8    , 301   , 335 , 3.54  , 3.57 , 14.6  , 0   , 1   , 5     , 8     ,  2L    |
      15.2 , 8    , 275.8 , 180 , 3.07  , 3.78 , 18    , 0   , 0   , 3     , 3     , 12L    |
      15.2 , 8    , 304   , 150 , 3.15  , 3.435, 17.3  , 0   , 0   , 3     , 2     ,  9L    |
      15.5 , 8    , 318   , 150 , 2.76  , 3.52 , 16.87 , 0   , 0   , 3     , 2     ,  8L    |
      15.8 , 8    , 351   , 264 , 4.22  , 3.17 , 14.5  , 0   , 1   , 5     , 4     ,  1L    |
      16.4 , 8    , 275.8 , 180 , 3.07  , 4.07 , 17.4  , 0   , 0   , 3     , 3     , 10L    |
      17.3 , 8    , 275.8 , 180 , 3.07  , 3.73 , 17.6  , 0   , 0   , 3     , 3     , 11L    |
      17.8 , 6    , 167.6 , 123 , 3.92  , 3.44 , 18.9  , 1   , 0   , 4     , 4     ,  2L    |
      18.1 , 6    , 225   , 105 , 2.76  , 3.46 , 20.22 , 1   , 0   , 3     , 1     ,  2L    |
      18.7 , 8    , 360   , 175 , 3.15  , 3.44 , 17.02 , 0   , 0   , 3     , 2     ,  5L    |
      19.2 , 6    , 167.6 , 123 , 3.92  , 3.44 , 18.3  , 1   , 0   , 4     , 4     ,  1L    |
      19.2 , 8    , 400   , 175 , 3.08  , 3.845, 17.05 , 0   , 0   , 3     , 2     ,  4L    |
      19.7 , 6    , 145   , 175 , 3.62  , 2.77 , 15.5  , 0   , 1   , 5     , 6     ,  1L    |
      21   , 6    , 160   , 110 , 3.9   , 2.62 , 16.46 , 0   , 1   , 4     , 4     ,  3L    |
      21   , 6    , 160   , 110 , 3.9   , 2.875, 17.02 , 0   , 1   , 4     , 4     ,  4L    |
      21.4 , 4    , 121   , 109 , 4.11  , 2.78 , 18.6  , 1   , 1   , 4     , 2     ,  3L    |
      21.4 , 6    , 258   , 110 , 3.08  , 3.215, 19.44 , 1   , 0   , 3     , 1     ,  1L    |
      21.5 , 4    , 120.1 , 97  , 3.7   , 2.465, 20.01 , 1   , 0   , 3     , 1     ,  1L    |
      22.8 , 4    , 108   , 93  , 3.85  , 2.32 , 18.61 , 1   , 1   , 4     , 1     ,  4L    |
      22.8 , 4    , 140.8 , 95  , 3.92  , 3.15 , 22.9  , 1   , 0   , 4     , 2     ,  2L    |
      24.4 , 4    , 146.7 , 62  , 3.69  , 3.19 , 20    , 1   , 0   , 4     , 2     ,  1L    |
      26   , 4    , 120.3 , 91  , 4.43  , 2.14 , 16.7  , 0   , 1   , 5     , 2     ,  1L    |
      27.3 , 4    , 79    , 66  , 4.08  , 1.935, 18.9  , 1   , 1   , 4     , 1     ,  5L    |
      30.4 , 4    , 75.7  , 52  , 4.93  , 1.615, 18.52 , 1   , 1   , 4     , 2     ,  7L    |
      30.4 , 4    , 95.1  , 113 , 3.77  , 1.513, 16.9  , 1   , 1   , 5     , 2     ,  2L    |
      32.4 , 4    , 78.7  , 66  , 4.08  , 2.2  , 19.47 , 1   , 1   , 4     , 1     ,  6L    |
      33.9 , 4    , 71.1  , 65  , 4.22  , 1.835, 19.9  , 1   , 1   , 4     , 1     ,  8L    )

  testthat::expect_equal(r1, r2, tolerance = 0.01)

  invisible(NULL)
})
