% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmute_nse.R
\name{transmute_nse}
\alias{transmute_nse}
\title{transmute non-standard evaluation interface.}
\usage{
transmute_nse(
  .data,
  ...,
  transmute_nse_env = parent.frame(),
  transmute_nse_warn = TRUE
)
}
\arguments{
\item{.data}{data.frame}

\item{...}{stringified expressions to transmute by.}

\item{transmute_nse_env}{environment to work in.}

\item{transmute_nse_warn}{logical, if TRUE warn about possible name collisions.}
}
\value{
.data with altered columns(other columns dropped).
}
\description{
transmute a data frame by the transmuteterms from \code{...}.
}
\examples{

datasets::iris \%.>\%
  transmute_nse(., Sepal_Long := Sepal.Length >= 2 * Sepal.Width,
                   Petal_Short := Petal.Length <= 3.5) \%.>\%
  summary(.)

}
\seealso{
\code{\link{transmute_se}}, \code{\link[dplyr]{transmute}}, \code{\link[dplyr]{transmute_at}}, \code{\link[wrapr]{:=}}
}
