% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComparePeds.R
\name{PedCompare}
\alias{PedCompare}
\title{Compare two Pedigrees}
\usage{
PedCompare(Ped1 = NULL, Ped2 = NULL, na1 = c(NA, "0"),
  DumPrefix = c("F0", "M0"), SNPd = NULL)
}
\arguments{
\item{Ped1}{original pedigree, dataframe with columns id-dam-sire; only the
first 3 columns will be used.}

\item{Ped2}{infered pedigree, e.g. \code{SeqOUT$Pedigree}, with columns
id-dam-sire.}

\item{na1}{the value for missing parents in Ped1 (assumed NA in Ped2).}

\item{DumPrefix}{character vector of length 2 with the dummy prefices in
Pedigree 2; all IDs not starting with the Dummy prefix are taken as
genotyped.}

\item{SNPd}{character vector with IDs of genotyped individuals.}
}
\value{
A list with
\item{Counts}{A 7 x 5 x 2 named numeric array with the number of matches and
  mismatches}
\item{MergedPed}{A side-by-side comparison of the two pedigrees}
\item{ConsensusPed}{A consensus pedigree, with Pedigree 2 taking priority
  over Pedigree 1}
\item{DummyMatch}{Dataframe with all dummy IDs in Pedigree 2 (id), and the
 best-matching individual in Pedigree 1 (id.r)}
\item{Mismatch}{A subset of MergedPed with mismatches between Ped1 and Ped2,
 as defined below. The two additional columns are Cat (category, 'GG', 'GD',
 'DG' or 'DD', as described below) and Parent ('dam' or 'sire' indicating
 which is mismatching)}
\item{Ped1only}{as Mismatches, with parents in Ped1 that were not assigned
  in Ped2}
\item{Ped2only}{as Mismatches, with parents in Ped2 that were missing in
  Ped1}

The first dimension of \code{Counts} denotes the following categories:
\item{GG}{Genotyped individual, assigned a genotyped parent in either
  pedigree}
\item{GD}{Genotyped individual, assigned a dummy parent, or at least 1
  genotyped sibling or a genotyped grandparent in Pedigree 1)}
\item{GT}{Genotyped individual, total}
\item{DG}{Dummy individual, assigned a genotyped parent (i.e., grandparent
   of the sibship in Pedigree 2)}
\item{DD}{Dummy individual, assigned a dummy parent (i.e., avuncular
  relationship between sibships in Pedigree 2)}
\item{DT}{Dummy total}
\item{TT}{Total total, includes all genotyped individuals, plus
  non-genotyped individuals in Pedigree 1, plus non-replaced dummy
  individuals (see below) in Pedigree 2}

The dummy individual count includes all non-genotyped individuals in
Pedigree 1 who have, according to either pedigree, at least 2 genotyped
offspring, or at least one genotyped offspring and a genotyped parent.

The second dimension of \code{Counts} gives the outcomes:
\item{Total}{The total number of individuals with a parent assigned in
   either or both pedigrees}
\item{Match}{The same parent is assigned in both pedigrees (non-missing).
     For dummy parents, it is considered a match if the inferred sibship
     which contains the most offspring of a non-genotyped parent, consists
     for more than half of this individual's offspring.}
\item{Mismatch}{Different parents assigned in the two pedigrees. When
   a sibship according to Pedigree 1 is split over two sibships in Pedigree
   2, the smaller fraction is included in the count here.}
\item{P1only}{Parent in Pedigree 1 but not 2; includes non-assignable
    parents (e.g. not genotyped and no genotyped offspring).}
\item{P2only}{Parent in Pedigree 2 but not 1.}

The third dimension \code{Counts} separates between maternal and paternal
assignments, where e.g. paternal 'DR' is the assignment of fathers to both
maternal and paternal sibships.

'MergedPed' provides the following columns:
\item{id}{All ids in both Pedigree 1 and 2}
\item{dam.1, sire.1}{parents in Pedigree 1}
\item{dam.2, sire.2}{parents in Pedigree 2}
\item{id.r, dam.r, sire.r}{when in Pedigree 2 a dummy parent is assigned,
  this column gives the best-matching non-genotyped individual according to
  Pedigree 1, or "nomatch". If a sibship in Pedigree 1 is divided over 2
  sibships in Pedigree 2, the smaller one will be denoted as "nomatch"}

In 'ConsensusPed', the priority used is parent.r (if not "nomatch) >
  parent.2 > parent.1. The columns 'dam.cat' and 'sire.cat' give a 2-letter
  code denoting whether the focal individual (first letter) and its assigned
  parent (2nd letter) are
  \item{G}{Genotyped}
  \item{D}{Dummy individual (in Pedigree 2)}
  \item{R}{Dummy individual in pedigree 2 replaced by best matching
   non-genotyped individual in pedigree 1}
  \item{U}{Ungenotyped (in Pedigree 1, with no dummy match)}
  \item{X}{No parent in either pedigree}
}
\description{
Compare an inferred pedigree (Ped2) to a previous or simulated
pedigree
 (Ped1), including comparison of sibship clusters and sibship grandparents.
}
\details{
The comparison is divided into different classes of `assignable'
parents.
This includes cases where the focal individual and parent according to Ped1
are both Genotyped (G-G), as well as cases where the non-genotyped parent
according to Ped1 can be lined up with a sibship Dummy parent in Ped2 (G-D),
or where the non-genotyped focal individual in Ped1 can be matched to a
dummy individual in Ped2 (D-G and D-D). If SNPd is NULL (the default), and
 DumPrefix is set to NULL, the intersect between the IDs in Pedigrees 1 and
  2 is taken as the vector of genotyped individuals.
}
\examples{
\dontrun{
data(Ped_HSg5, SimGeno_example, LH_HSg5, package="sequoia")
SeqOUT <- sequoia(GenoM = SimGeno_example, LifeHistData = LH_HSg5)
compare <- PedCompare(Ped1=Ped_HSg5, Ped2=SeqOUT$Pedigree)
compare$Counts   # 2 mismatches, due to simulated genotyping errors
head(compare$MergedPed)

PedM <- compare$MergedPed
# find mismatching mothers:
with(PedM, PedM[which(dam.1!=dam.2 & dam.1!=dam.r),])

# find mothers in Ped1 which are genotyped but not assigned in Ped2:
with(PedM, PedM[which(is.na(dam.2) & !is.na(dam.1) &
                       !is.na(id) & dam.1 \%in\% id),])
}
}
\seealso{
\code{\link{DyadCompare}, \link{sequoia}}.
}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
