% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MkAgePrior.R
\name{MakeAgePrior}
\alias{MakeAgePrior}
\title{Age Priors}
\usage{
MakeAgePrior(
  Pedigree = NULL,
  LifeHistData = NULL,
  MinAgeParent = NULL,
  MaxAgeParent = NULL,
  Discrete = NULL,
  Flatten = NULL,
  lambdaNW = -log(0.5)/100,
  Smooth = TRUE,
  Plot = TRUE,
  Return = "LR",
  quiet = FALSE
)
}
\arguments{
\item{Pedigree}{dataframe with id - dam - sire in columns 1-3, and optional
column with birth years. Other columns are ignored.}

\item{LifeHistData}{dataframe with 3 or 5 columns: id - sex (not used) -
birthyear (optional columns BY.min - BY.max - YearLast not used), with
unknown birth years coded as negative numbers or NA. "Birth year" may be in
any arbitrary discrete time unit relevant to the species (day, month,
decade), as long as parents are never born in the same time unit as their
offspring. It may include individuals not in the pedigree, and not all
individuals in the pedigree need to be in LifeHistData.}

\item{MinAgeParent}{minimum age of a parent, a single number (min across
dams and sires) or a vector of length two (dams, sires). Defaults to 1.}

\item{MaxAgeParent}{maximum age of a parent, a single number (max across
dams and sires) or a vector of length two (dams, sires). If NULL, it will
be set to latest - earliest birth year in \code{LifeHistData}, or estimated
from the pedigree if one is provided. See details below.}

\item{Discrete}{discrete generations? By default (NULL), discrete
generations are assumed if all parent-offspring pairs have an age
difference of 1, and all siblings an age difference of 0, and there are at
least 20 pairs of each category (mother, father, maternal sibling, paternal
sibling). Otherwise, overlapping generations are presumed. When
\code{Discrete=TRUE} (explicitly or deduced), \code{Smooth} and
\code{Flatten} are always automatically set to \code{FALSE}. Use
\code{Discrete=FALSE} to enforce (potential for) overlapping generations.}

\item{Flatten}{logical. To deal with small sample sizes for some or all
relationships, calculate weighed average between the observed age
difference distribution among relatives and a flat (0/1) distribution. When
\code{Flatten=NULL} (the default) automatically set to TRUE when there are
fewer than 20 parents with known age of either sex assigned, or fewer than
20 maternal or paternal siblings with known age difference. Also advisable
if the sampled relative pairs with known age difference are non-typical of
the pedigree as a whole.}

\item{lambdaNW}{control weighing factors when \code{Flatten=TRUE}. Weights
are calculated as \eqn{W(R) = 1 - exp(-lambdaNW * N(R))}, where \eqn{N(R)}
is the number of pairs with relationship R for which the age difference is
known. Large values (>0.2) put strong emphasis on the pedigree, small
values (<0.0001) cause the pedigree to be ignored. Default results in
\eqn{W=0.5} for \eqn{N=100}.}

\item{Smooth}{smooth the tails of and any dips in the distribution? Sets dips
(<10\% of average of neighbouring ages) to the average of the neighbouring
ages, sets the age after the end (oldest observed age) to LR(end)/2, and
assigns a small value (0.001) to the ages before the front (youngest
observed age) and after the new end. Peaks are not smoothed out, as these
are less likely to cause problems than dips, and are more likely to be
genuine characteristics of the species. Is set to \code{FALSE} when
generations do not overlap (\code{Discrete=TRUE}).}

\item{Plot}{plot a heatmap of the results?}

\item{Return}{return only a matrix with the likelihood-ratio \eqn{P(A|R) /
P(A)} (\code{"LR"}) or a list including also various intermediate
statistics (\code{"all"}) ?}

\item{quiet}{suppress messages.}
}
\value{
A matrix with the probability ratio of the age difference between two
  individuals conditional on them being a certain type of relative
  (\eqn{P(A|R)}) versus being a random draw from the sample (\eqn{P(A)}).
  Assuming conditional independence, this equals the probability ratio of
  being a certain type of relative conditional on the age difference, versus
  being a random draw.

  The matrix has one row per age difference (0 - nAgeClasses) and five
  columns, one for each relationship type, with abbreviations:
  \item{M}{Mothers}
  \item{P}{Fathers}
  \item{FS}{Full siblings}
  \item{MS}{Maternal half-siblings}
  \item{PS}{Paternal half-siblings}

  When \code{Return}='all', a list is returned with the following elements:
   \item{BirthYearRange}{vector length 2}
   \item{MaxAgeParent}{vector length 2, see details}
   \item{tblA.R}{matrix with the counts per age difference (rows) /
     relationship (columns) combination, plus a column 'X' with age
     differences across all pairs of individuals}
  \item{PA.R}{Proportions, i.e. \code{tblA.R} divided by its \code{colSums},
    with full-sibling correction applied if necessary (see vignette).}
   \item{LR.RU.A.raw}{Proportions \code{PA.R} standardised by global age
     difference distribution (column 'X'); \code{LR.RU.A} prior to flattening
     and smoothing}
   \item{Weights}{vector length 4, the weights used to flatten the
    distributions}
    \item{LR.RU.A}{the ageprior, flattend and/or smoothed}
   \item{Specs.AP}{the names of the input \code{Pedigree} and
   \code{LifeHistData} (or \code{NULL}), \code{lambdaNW}, and the 'effective'
     settings (i.e. after any automatic update) of \code{Discrete},
     \code{Smooth}, and \code{Flatten}.}
}
\description{
Estimate probability ratios \eqn{P(R|A) / P(R)} for age
  differences A and five categories of parent-offspring and sibling
  relationships R.
}
\details{
\eqn{\alpha_{A,R}} is the ratio between the observed
  counts of pairs with age difference A and relationship R (\eqn{N_{A,R}}),
  and the expected counts if age and relationship were independent
  (\eqn{N_{.,.}*p_A*p_R}).

  During pedigree reconstruction, \eqn{\alpha_{A,R}} are multiplied by the
  genetic-only \eqn{P(R|G)} to obtain a probability that the
  pair are relatives of type R conditional on both their age difference and
  their genotypes.

  The age-difference prior is used for pairs of genotyped individuals, as
  well as for dummy individuals. This assumes that the propensity for a pair
  with a given age difference to both be sampled does not depend on their
  relationship, so that the ratio \eqn{P(A|R) / P(A)} does not differ between
  sampled and unsampled pairs.

  For further details, see the vignette.
}
\section{CAUTION}{

  The small sample correction with \code{Smooth} and/or \code{Flatten}
  prevents errors in one dataset, but may introduce errors in another; a
  single solution that fits to the wide variety of life histories and
  datasets is impossible. Please do inspect the matrix, e.g. with
  \code{PlotAgePrior}, and adjust the input parameters and/or the output
  matrix as necessary.
}

\section{Single cohort}{

  When all individuals in \code{LifeHistData} have the same birth year, it is
  assumed that \code{Discrete=TRUE} and \code{MaxAgeParent=1}. Consequently,
  it is assumed there are no avuncular pairs present in the sample; cousins
  are considered as alternative. To enforce overlapping generations, and
  thereby the consideration of full- and half- avuncular relationships, set
  \code{MaxAgeParent} to some value greater than \eqn{1}.

 When no birth year information is given at all, a single cohort is assumed,
 and the same rules apply.
}

\section{Other time units}{

  "Birth year" may be in any arbitrary time unit relevant to the species
  (day, month, decade), as long as parents are always born before their
  putative offspring, and never in the same time unit (e.g. parent's
  BirthYear= 1 (or 2001) and offspring BirthYear=5 (or 2005)). Negative
  numbers and NA's are interpreted as unknown, and fractional numbers are not
  allowed.
}

\section{MaxAgeParent}{

  The maximum parental age for each sex equals the maximum of:
 \itemize{
   \item the maximum age of parents in \code{Pedigree},
   \item the input parameter \code{MaxAgeParent},
   \item the maximum range of birth years in \code{LifeHistData} (including
     BY.min and BY.max). Only used if both of the previous are \code{NA}, or
     if there are fewer than 20 parents of either sex assigned.
   \item 1, if \code{Discrete=TRUE} or the previous three are all \code{NA}
 }
 If the age distribution of assigned parents does not capture the maximum
 possible age of parents, it is advised to specify \code{MaxAgeParent} for
 one or both sexes. Not doing so may hinder subsequent assignment of both
 dummy parents and grandparents. Not compatible with \code{Smooth}.

 @section grandparents & avuncular
 The agepriors for grand-parental and avuncular pairs is calculated from
 these by \code{\link{sequoia}}, and included in its output as
 `AgePriorExtra`.
}

\examples{
# without pedigree or lifehistdata:
MakeAgePrior(MaxAgeParent = c(2,3))
MakeAgePrior(Discrete=TRUE)

# single cohort:
MakeAgePrior(LifeHistData = data.frame(ID = letters[1:5], Sex=3,
  BirthYear=1984))

# overlapping generations:
# without pedigree: MaxAgeParent = max age difference between any pair +1
MakeAgePrior(LifeHistData = SeqOUT_griffin$LifeHist)
# with pedigree:
MakeAgePrior(Pedigree=Ped_griffin,
             LifeHistData=SeqOUT_griffin$LifeHist,
             Smooth=FALSE, Flatten=FALSE)
# with small-sample correction:
MakeAgePrior(Pedigree=Ped_griffin,
             LifeHistData=SeqOUT_griffin$LifeHist,
             Smooth=TRUE, Flatten=TRUE)

# Call from sequoia() via args.AP:
Seq_HSg5 <- sequoia(SimGeno_example, LH_HSg5, Module="par",
                args.AP=list(Discrete = TRUE),  # non-overlapping generations
                CalcLLR = FALSE,   # skip time-consuming calculation of LLR's
                Plot = FALSE)      # no summary plots when finished

}
\seealso{
\code{\link{sequoia}} and its argument \code{args.AP},
  \code{\link{PlotAgePrior}} for visualisation. The age vignette gives
  further details, mathematical justification, and some examples.
}
