% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rest-api.r
\name{drill_opts}
\alias{drill_opts}
\title{Show all the available Drill options}
\usage{
drill_opts(drill_con, browse = FALSE)
}
\arguments{
\item{drill_con}{drill server connection object setup by \code{drill_connection()}}

\item{browse}{if \code{TRUE} display an HTML interacrtive HTML widget with the options
as well as reutrn the data frame with the options Default if \code{FALSE}.}
}
\value{
data frame
}
\description{
Show all the available Drill options
}
\note{
You \emph{must} be using Drill 1.15.0+ to use this function
}
\examples{
\dontrun{
drill_connection() \%>\% drill_opts()
}
}
\references{
\href{https://drill.apache.org/docs/querying-system-tables/#querying-the-options-table}{Drill documentation}
}
\seealso{
Other Drill direct REST API Interface: 
\code{\link{drill_active}()},
\code{\link{drill_cancel}()},
\code{\link{drill_connection}()},
\code{\link{drill_functions}()},
\code{\link{drill_metrics}()},
\code{\link{drill_options}()},
\code{\link{drill_profiles}()},
\code{\link{drill_profile}()},
\code{\link{drill_query}()},
\code{\link{drill_settings_reset}()},
\code{\link{drill_set}()},
\code{\link{drill_stats}()},
\code{\link{drill_status}()},
\code{\link{drill_storage}()},
\code{\link{drill_system_reset}()},
\code{\link{drill_threads}()},
\code{\link{drill_version}()}
}
\concept{Drill direct REST API Interface}
