% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setartree-package.R
\docType{package}
\name{setartree-package}
\alias{setartree-package}
\title{Getting started with the setartree package}
\description{
The setartree is a library containing the implementations of SETAR-Tree and SETAR-Forest
which are forecasting-specific tree-based models that are in particular suitable for global time series forecasting.
}
\details{
If you have problems using setartree, find a bug, or have suggestions, please
file an issue on github (bugs/suggestions). If that fails, then you can contact the maintainer
directly by email.

If you use the package, please cite the following work in your publications:

Godahewa, R., Webb, G. I., Schmidt, D., & Bergmeir, C. (2023). SETAR-Tree: A novel and accurate tree algorithm for
global time series forecasting. Machine Learning, 112, 2555-2591. \doi{10.1007/s10994-023-06316-x}

Demos for using SETAR-Tree and SETAR-Forest are available.
To get a list of them, type:

\code{library(setartree)}

\code{demo()}

To execute the SETAR-Tree demo, type:

\code{demo(tree_demo)}

To execute the SETAR-Forest demo, type:

\code{demo(forest_demo)}

To fit a SETAR-Tree model either using a list of time series or an embedded input matrix and labels,
use the function \code{\link{setartree}}.
To fit a SETAR-Forest model either using a list of time series or an embedded input matrix and labels,
use the function \code{\link{setarforest}}.
To obtain forecasts from a SETAR-Tree or a SETAR-Forest, use the functions \code{\link{forecast.setartree}} and \code{\link{forecast.setarforest}}, respectively.

The setartree package also contains three datasets that can be used to train/test the SETAR-Tree and SETAR-Forest models:
\code{\link{chaotic_logistic_series}}, \code{\link{web_traffic_train}} and \code{\link{web_traffic_test}}.

See the setartree user manual for detailed explanations about the datasets and the parameters taken by each function.

Another nice tool is the \code{forecast} package, that can be used to
plot the time series together with the forecasts generated by SETAR-Tree or SETAR-Forest.
}
\references{
Godahewa, R., Webb, G. I., Schmidt, D., & Bergmeir, C. (2023). SETAR-Tree: A novel and accurate tree algorithm for
global time series forecasting. Machine Learning, 112, 2555-2591. \doi{10.1007/s10994-023-06316-x}
}
\author{
Rakshitha Godahewa \email{rakshithagw@gmail.com}

Christoph Bergmeir \email{christoph.bergmeir@monash.edu}

Daniel Schmidt \email{daniel.schmidt@monash.edu}

and Geoffrey Webb \email{geoff.webb@monash.edu}

Department of Data Science and AI, Faculty of Information Technology, Monash University, Australia.

\url{https://www.monash.edu/it/dsai}
}
\keyword{forecasting}
\keyword{package}
\keyword{setartree}
