% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-projects.R
\name{Projects}
\alias{Projects}
\title{R6 Class representing a projects endpoints.}
\description{
R6 Class representing Projects resource.
}
\examples{

## ------------------------------------------------
## Method `Projects$query`
## ------------------------------------------------

\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Query projects
 projects_object$query(name = name)
}


## ------------------------------------------------
## Method `Projects$get`
## ------------------------------------------------

\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Get project by id
 projects_object$get(id = id)
}


## ------------------------------------------------
## Method `Projects$delete`
## ------------------------------------------------

\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Delete a project
 projects_object$delete(project = project)
}


## ------------------------------------------------
## Method `Projects$create`
## ------------------------------------------------

\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Create a project
 projects_object$create(
                    name = name,
                    billing_group = billing_group,
                    description = description
                  )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Projects}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Projects-new}{\code{Projects$new()}}
\item \href{#method-Projects-query}{\code{Projects$query()}}
\item \href{#method-Projects-get}{\code{Projects$get()}}
\item \href{#method-Projects-delete}{\code{Projects$delete()}}
\item \href{#method-Projects-create}{\code{Projects$create()}}
\item \href{#method-Projects-clone}{\code{Projects$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-new"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-new}{}}}
\subsection{Method \code{new()}}{
Create new Projects resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-query"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-query}{}}}
\subsection{Method \code{query()}}{
A method to list all projects available to particular user.
If the username is not provided, all projects available to the
currently authenticated user will be listed.
Otherwise, projects will be listed for the user whose username
is provided.
Please keep in mind that this way you will only be able to list
projects you are a member of. \cr \cr
More details on how to query projects, you can find in our
\href{https://docs.sevenbridges.com/reference/list-all-your-projects}{documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$query(
  name = NULL,
  owner = NULL,
  tags = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Project's name.}

\item{\code{owner}}{The username of the owner whose projects you want to query.}

\item{\code{tags}}{A list of project tags used to filter the query results.
Each tag should be provided as a string within the list, and tags may
include spaces. For example, both "my_tag_1" and "tag with spaces" are
valid tag values. The method will return only projects that have all
the specified tags.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like other query parameters or 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Project}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Query projects
 projects_object$query(name = name)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-get"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-get}{}}}
\subsection{Method \code{get()}}{
This call creates Project object containing the details
of a specified project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Project ID. It consists of project owner's username or
if you are using Enterprise, then the Division name and project's
short name in form of \verb{<owner_username>/<project-short-name>} or
\verb{<division-name>/<project-short-name>}.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Project}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Get project by id
 projects_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-delete}{}}}
\subsection{Method \code{delete()}}{
Method that allows you to delete project from a platform.
It can only be successfully made if you have admin status for the
project. \cr Projects are specified by their IDs, which you can obtain by
using \code{Projects$query()} to list projects or by getting a
single project using \code{Projects$get()}.
Please be careful when using this method and note that calling it will
permanently delete the project from the platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$delete(project, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{\code{\link{Project}} object or project ID.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
as 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Delete a project
 projects_object$delete(project = project)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-create"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-create}{}}}
\subsection{Method \code{create()}}{
A method for creating a new project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$create(
  name,
  billing_group = NULL,
  description = name,
  tags = NULL,
  locked = FALSE,
  controlled = FALSE,
  location = NULL,
  use_interruptible_instances = TRUE,
  use_memoization = FALSE,
  use_elastic_disk = FALSE,
  intermediate_files = list(retention = "LIMITED", duration = 24),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the project you are creating.}

\item{\code{billing_group}}{The Billing object or ID of the billing group for
the project.}

\item{\code{description}}{Description of the project.}

\item{\code{tags}}{The list of project tags.}

\item{\code{locked}}{Set this field to \code{TRUE} to lock down a project.
Locking down a project prevents any Seven Bridges team member from
viewing any information about the task.}

\item{\code{controlled}}{Set this field to \code{TRUE} to define this project as
controlled i.e. one which will contain controlled data. Set \code{FALSE} to
define the project as open i.e. one which will contain open data.}

\item{\code{location}}{Specify the location for this project:
\code{aws:us-east-1} or \code{aws:us-west-2}.}

\item{\code{use_interruptible_instances}}{Defines the use of
\href{https://docs.sevenbridges.com/docs/about-spot-instances}{spot instances}.}

\item{\code{use_memoization}}{Set to \code{FALSE} by default. Set to \code{TRUE} to enable
\href{https://docs.sevenbridges.com/docs/about-memoization}{memoization}.}

\item{\code{use_elastic_disk}}{Set to \code{TRUE} to enable
\href{https://docs.sevenbridges.com/page/elastic-disk}{Elastic disk}.}

\item{\code{intermediate_files}}{A list defining the retention period for
intermediate files. Expected elements:
\itemize{
\item \code{retention} - Specifies that intermediate files should be
retained for a limited amount of time.
The value is always \code{LIMITED}.
\item \code{duration} - Specifies intermediate files retention period in
hours. The minimum value is \code{1}. The maximum value is \code{120} and the
default value is \code{24}.
}}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Project}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 projects_object <- Projects$new(auth = auth)

 # Create a project
 projects_object$create(
                    name = name,
                    billing_group = billing_group,
                    description = description
                  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projects-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Projects-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projects$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
