% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{gdal_addo}
\alias{gdal_addo}
\title{add or remove overviews to/from a raster image}
\usage{
gdal_addo(
  file,
  overviews = c(2, 4, 8, 16),
  method = "NEAREST",
  layers = integer(0),
  options = character(0),
  clean = FALSE,
  read_only = FALSE
)
}
\arguments{
\item{file}{character; file name}

\item{overviews}{integer; overview levels}

\item{method}{character; method to create overview; one of: nearest, average, rms, gauss, cubic, cubicspline, lanczos, average_mp, average_magphase, mode}

\item{layers}{integer; layers to create overviews for (default: all)}

\item{options}{character; dataset opening options}

\item{clean}{logical; if \code{TRUE} only remove overviews, do not add}

\item{read_only}{logical; if \code{TRUE}, add overviews to another file with extension \code{.ovr} added to \code{file}}
}
\value{
\code{TRUE}, invisibly, on success
}
\description{
add or remove overviews to/from a raster image
}
\seealso{
\link{gdal_utils} for access to other gdal utilities that have a C API
}
