% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbors.R
\name{st_dist_band}
\alias{st_dist_band}
\title{Neighbors from a distance band}
\usage{
st_dist_band(geometry, lower = 0, upper = critical_threshold(geometry), ...)
}
\arguments{
\item{geometry}{An sf or sfc object.}

\item{lower}{The lower threshold of the distance band. It is recommended to keep this as 0.}

\item{upper}{The upper threshold of the distance band. By default is set to a critical threshold using \code{\link[=critical_threshold]{critical_threshold()}} ensuring that each region has a minimum of one neighbor.}

\item{...}{Passed to \code{spdep::dnearneigh()}.}
}
\value{
a list of class \code{nb}
}
\description{
Creates neighbors based on a distance band. By default, creates a distance band with the maximum distance of k-nearest neighbors where k = 1 (the critical threshold) to ensure that there are no regions that are missing neighbors.
}
\examples{
geo <- sf::st_geometry(guerry)
st_dist_band(geo, upper = critical_threshold(geo))
}
\seealso{
Other neighbors: 
\code{\link{st_contiguity}()},
\code{\link{st_knn}()}
}
\concept{neighbors}
