% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sgd.R
\name{sgd}
\alias{sgd}
\alias{sgd.formula}
\alias{sgd.function}
\alias{sgd.matrix}
\title{Stochastic gradient descent}
\usage{
sgd(x, ...)

\method{sgd}{formula}(formula, data, model, model.control = list(),
  sgd.control = list(...), ...)

\method{sgd}{function}(x, fn.control = list(), sgd.control = list(...), ...)

\method{sgd}{matrix}(x, y, model, model.control = list(),
  sgd.control = list(...), ...)
}
\arguments{
\item{x}{for \code{sgd.function}, x is a function to minimize; for
\code{sgd.matrix}, x is a design matrix.}

\item{formula}{an object of class \code{"\link{formula}"} (or one that can be
coerced to that class): a symbolic description of the model to be fitted.
The details can be found in \code{"\link{glm}"}.}

\item{data}{an optional data frame, list or environment (or object coercible
by \code{\link[base]{as.data.frame}} to a data frame) containing the
variables in the model. If not found in data, the variables are taken from
environment(formula), typically the environment from which glm is called.}

\item{model}{character specifying the model to be used: \code{"lm"} (linear
model), \code{"glm"} (generalized linear model).}

\item{model.control}{a list of parameters for controlling the model.
\itemize{
  \item family (\code{"glm"}): a description of the error distribution and
    link function to be used in the model. This can be a character string
    naming a family function, a family function or the result of a call to
    a family function.  (See \code{\link[stats]{family}} for details of
    family functions.)
  \item intercept (\code{"lm"}, \code{"glm"}): logical. Should an intercept
    be included in the \emph{null} model?
}}

\item{sgd.control}{a list of parameters for controlling the estimation
\itemize{
  \item method: character specifying the method to be used: \code{"sgd"},
    \code{"implicit"}, \code{"asgd"}. Default is \code{"implicit"}. See
    \sQuote{Details}.
  \item lr.type: character specifying the learning rate to be used:
    \code{"uni-dim"}, \code{"uni-dim-eigen"}, \code{"p-dim"},
    \code{"p-dim-weighted"}, \code{"adagrad"}. Default is \code{"uni-dim"}.
    See \sQuote{Details}.
  \item start: starting values for the parameter estimates. Default is
    random initialization around the mean.
  \item weights: an optional vector of "prior weights" to be used in the
    fitting process. Should be NULL or a numeric vector.
  \item offset: this can be used to specify an a priori known component to
    be included in the linear predictor during fitting. This should be NULL
    or a numeric vector of length equal to the number of cases. One or more
    offset terms can be included in the formula instead or as well, and if
    more than one is specified their sum is used. See
    \code{\link[stats]{offset}}
}}

\item{fn.control}{for \code{sgd.function}, it is a list of controls for the
function.}

\item{y}{for {sgd.matrix}, y is a vector of observations, with length equal
to the number of rows in x.}

\item{\dots}{arguments to be used to form the default \code{sgd.control}
arguments if it is not supplied directly.}
}
\value{
An object of class \code{"sgd"}, which is a list containing at least the
following components:

\code{coefficients}
a named vector of coefficients

\code{residuals}
the \emph{working} residuals, that is the residuals in the final iteration of
the fit. Since cases with zero weights are omitted, their working residuals
are NA.

\code{fitted.values}
the fitted mean values, obtained by transforming the linear predictors by the
inverse of the link function.

\code{rank}
the numeric rank of the fitted linear model.

\code{family}
the \code{\link[stats]{family}} object used.

\code{linear.predictors}
the linear fit on link scale.

\code{deviance}
up to a constant, minus twice the maximized log-likelihood. Where sensible,
the constant is chosen so that a saturated model has deviance zero.

\code{null.deviance}
The deviance for the null model, comparable with \code{deviance}. The null
model will include the offset, and an intercept if there is one in the model.
Note that this will be incorrect if the link function depends on the data
other than through the fitted mean: specify a zero offset to force a correct
calculation.

\code{iter}
the number of iterations of the algorithm used.

\code{weights}
the weights initially supplied, a vector of 1s if none were.

\code{df.residual}
the residual degrees of freedom.

\code{df.null}
the residual degrees of freedom for the null model.

\code{converged}
logical. Was the algorithm judged to have converged?
}
\description{
Run stochastic gradient descent on the underlying loss function for a given
model and data, or a user-specified loss function.
}
\details{
Methods: "sgd" uses stochastic gradient descent (Robbins and Monro, 1951).
"implicit" uses implicit stochastic gradient descent (Toulis et al., 2014).
"asgd" uses stochastic gradient with averaging (Polyak and Juditsky, 1992).

Learning rates: "uni-dim" uses the one-dimensional learning rate.  The
method "p-dim" uses the p-dimensional learning rate.  The method "adagrad"
uses a diagonal scaling (Duchi et al., 2011).
}
\examples{
## Dobson (1990, p.93): Randomized Controlled Trial
counts <- c(18, 17, 15, 20, 10, 20, 25, 13, 12)
outcome <- gl(3, 1, 9)
treatment <- gl(3, 3)
print(d.AD <- data.frame(treatment, outcome, counts))
sgd.D93 <- sgd(counts ~ outcome + treatment, model="glm",
               model.control=list(family = poisson()))
sgd.D93

## Venables & Ripley (2002, p.189): an example with offsets
utils::data(anorexia, package="MASS")

anorex.1 <- sgd(Postwt ~ Prewt + Treat + offset(Prewt),
                data=anorexia, model="lm")
}
\author{
Dustin Tran, Tian Lan, Panos Toulis, Ye Kuang, Edoardo Airoldi
}
\references{
John Duchi, Elad Hazan, and Yoram Singer. Adaptive subgradient methods for
online learning and stochastic optimization. \emph{Journal of Machine
Learning Research}, 12:2121-2159, 2011.

Boris T. Polyak and Anatoli B. Juditsky. Acceleration of stochastic
approximation by averaging. \emph{SIAM Journal on Control and Optimization},
30(4):838-855, 1992.

Herbert Robbins and Sutton Monro. A stochastic approximation method.
\emph{The Annals of Mathematical Statistics}, pp. 400-407, 1951.

Panos Toulis, Jason Rennie, and Edoardo M. Airoldi, "Statistical analysis of
stochastic gradient methods for generalized linear models", In
\emph{Proceedings of the 31st International Conference on Machine Learning},
2014.
}

