% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{getParams}
\alias{getParams}
\title{Get current parameter values}
\usage{
getParams(sgmcmc, sess)
}
\arguments{
\item{sgmcmc}{a stochastic gradient MCMC object returned by *Setup such as 
\code{\link{sgldSetup}}, \code{\link{sgldcvSetup}} etc.}

\item{sess}{a TensorFlow session created using \code{\link{initSess}}}
}
\value{
Returns a list with the same names as \code{params}, with \code{R} arrays of the current
 parameter values
}
\description{
Return the current parameter values as a list of R arrays (converted from TensorFlow tensors).
}
\examples{
\dontrun{
# Simulate from a Normal Distribution, unknown location and known scale with uninformative prior
# Run sgmcmc step by step and calculate estimate of location on the fly to reduce storage
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) {
    distn = tf$contrib$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 1e-4)
sgld = sgldSetup(logLik, dataset, params, stepsize)
nIters = 10^4L
# Initialize location estimate
locEstimate = 0
# Initialise TensorFlow session
sess = initSess(sgld)
for ( i in 1:nIters ) {
    sgmcmcStep(sgld, sess)
    locEstimate = locEstimate + 1 / nIters * getParams(sgld, sess)$theta
}
# For more examples see vignettes
}
}
