% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgldcv.R
\name{sgldcvSetup}
\alias{sgldcvSetup}
\title{Create an sgldcv object}
\usage{
sgldcvSetup(logLik, dataset, params, stepsize, optStepsize, logPrior = NULL,
  minibatchSize = 0.01, nItersOpt = 10^4L, verbose = TRUE, seed = NULL)
}
\arguments{
\item{logLik}{function which takes parameters and dataset 
(list of TensorFlow variables and placeholders respectively) as input. 
It should return a TensorFlow expression which defines the log likelihood of the model.}

\item{dataset}{list of numeric R arrays which defines the datasets for the problem.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{params}{list of numeric R arrays which define the starting point of each parameter.
The names in the list should correspond to those referred to in the logLik and logPrior functions}

\item{stepsize}{list of numeric values corresponding to the SGLD stepsizes for each parameter
The names in the list should correspond to those in params.
Alternatively specify a single numeric value to use that stepsize for all parameters.}

\item{optStepsize}{numeric value specifying the stepsize for the optimization 
to find MAP estimates of parameters. The TensorFlow GradientDescentOptimizer is used.}

\item{logPrior}{optional. Default uninformative improper prior.
Function which takes parameters (list of TensorFlow variables) as input.
The function should return a TensorFlow tensor which defines the log prior of the model.}

\item{minibatchSize}{optional. Default 0.01.
Numeric or integer value that specifies amount of dataset to use at each iteration 
either as proportion of dataset size (if between 0 and 1) or actual magnitude (if an integer).}

\item{nItersOpt}{optional. Default 10^4L. 
Integer specifying number of iterations of initial optimization to perform.}

\item{verbose}{optional. Default TRUE. Boolean specifying whether to print algorithm progress}

\item{seed}{optional. Default NULL. Numeric seed for random number generation. The default
does not declare a seed for the TensorFlow session.}
}
\value{
The function returns an 'sgldcv' object, a type of sgmcmc object. 
 Which is used to pass the required information about the current model to the 
 \code{\link{sgmcmcStep}} function. The function \code{\link{sgmcmcStep}} runs one 
 step of sgld with a gradient estimate that uses control variates. 
 Attributes of the sgldcv object you'll probably find most useful are:
\describe{
\item{params}{list of tf$Variables with the same names as the params list passed to
 \code{\link{sgldcvSetup}}. This is the object passed to the logLik and logPrior functions you
 declared to calculate the log posterior gradient estimate.}
\item{paramsOpt}{list of tf$Variables with the same names as the \code{params} list passed to
 \code{\link{sgldcvSetup}}. These variables are used to initially find MAP estimates
 and then store these optimal parameter estimates.}
\item{estLogPost}{a tensor that estimates the log posterior given the current 
 placeholders and params.}
\item{logPostOptGrad}{list of \code{tf$Variables} with same names as \code{params}, this stores
 the full log posterior gradient at each MAP estimate after the initial optimization step.}}
 Other attributes of the object are as follows:
\describe{
\item{N}{dataset size.}
\item{data}{dataset as passed to \code{\link{sgldcvSetup}}.}
\item{n}{minibatchSize as passed to \code{\link{sgldcvSetup}}.}
\item{placeholders}{list of tf$placeholder objects with the same names as dataset
 used to feed minibatches of data to \code{\link{sgmcmcStep}}. These are also the objects
 that gets fed to the dataset argument of the logLik and logPrior functions you declared.}
\item{stepsize}{list of stepsizes as passed to \code{\link{sgldcvSetup}}}
\item{dynamics}{a list of TensorFlow steps that are evaluated by \code{\link{sgmcmcStep}}.}
\item{estLogPostOpt}{a TensorFlow tensor relying on \code{paramsOpt} and \code{placeholders} which
 estimates the log posterior at the optimal parameters. Used in the initial optimization step.}
\item{fullLogPostOpt}{a TensorFlow tensor used in the calculation of the full log posterior
 gradient at the MAP estimates.}
\item{optimizer}{a TensorFlow optimizer object used to find the initial MAP estimates.}}
}
\description{
Creates an sgldcv (stochastic gradient Langevin Dynamics with Control Variates) object 
 which can be passed to \code{\link{sgmcmcStep}} to simulate from 1 step of sgld, using a 
 gradient estimate with control variates for the posterior defined by logLik and logPrior.
 This allows the user to code the loop themselves, as in many standard 
 TensorFlow procedures (such as optimization). Which means they do not need to store 
 the chain at each iteration. This is useful when the full chain needs a lot of memory.
}
\examples{
\dontrun{
# Simulate from a Normal Distribution, unknown location and known scale with uninformative prior
# Run sgmcmc step by step and calculate estimate of location on the fly to reduce storage
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) {
    distn = tf$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 1e-4)
optStepsize = 1e-1
sgldcv = sgldcvSetup(logLik, dataset, params, stepsize, optStepsize)
nIters = 10^4L
# Initialize location estimate
locEstimate = 0
# Initialise TensorFlow session
sess = initSess(sgldcv)
for ( i in 1:nIters ) {
    sgmcmcStep(sgldcv, sess)
    locEstimate = locEstimate + 1 / nIters * getParams(sgldcv, sess)$theta
}
# For more examples see vignettes
}
}
