% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_get_model_from_checkp}
\alias{vaeac_get_model_from_checkp}
\title{Function to load a \code{vaeac} model and set it in the right state and mode}
\usage{
vaeac_get_model_from_checkp(checkpoint, cuda, mode_train)
}
\arguments{
\item{checkpoint}{List. This must be a loaded \code{vaeac} save object. That is, \code{torch::torch_load('vaeac_save_path')}.}

\item{cuda}{Logical (default is \code{FALSE}). If \code{TRUE}, then the \code{vaeac} model will be trained using cuda/GPU.
If \code{\link[torch:cuda_is_available]{torch::cuda_is_available()}} is \code{FALSE}, the we fall back to use CPU. If \code{FALSE}, we use the CPU. Using a GPU
for smaller tabular dataset often do not improve the efficiency.
See \code{vignette("installation", package = "torch")} fo help to enable running on the GPU (only Linux and Windows).}

\item{mode_train}{Logical. If \code{TRUE}, the returned \code{vaeac} model is set to be in training mode.
If \code{FALSE}, the returned \code{vaeac} model is set to be in evaluation mode.}
}
\value{
A \code{vaeac} model with the correct state (based on \code{checkpoint}), sent to the desired hardware (based on
\code{cuda}), and in the right mode (based on \code{mode_train}).
}
\description{
Function to load a \code{vaeac} model and set it in the right state and mode
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
