% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_habitats.R
\name{classify_habitats}
\alias{classify_habitats}
\title{classify_habitats}
\usage{
classify_habitats(raster, classes = 5, style = "fisher")
}
\arguments{
\item{raster}{RasterLayer.}

\item{classes}{Number of classes.}

\item{style}{Style of classification.}
}
\value{
RasterLayer
}
\description{
Classify habitats
}
\details{
Classifies a RasterLayer with continuous values into n discrete classes. Consequently,
classes are non-overlapping (and left-closed). For more information see `classIntervals`.
}
\examples{
landscape_classified <- classify_habitats(landscape, classes = 5)

}
\references{
Armstrong, M. P., Xiao, N., Bennett, D. A., 2003. "Using genetic algorithms
to create multicriteria class intervals for choropleth maps". Annals,
Association of American Geographers, 93 (3), 595-623

Jenks, G. F., Caspall, F. C., 1971. "Error on choroplethic maps: definition,
measurement, reduction". Annals, Association of American Geographers, 61 (2), 217-244

Dent, B. D., 1999, Cartography: thematic map design. McGraw-Hill, Boston, 417 pp.
Slocum TA, McMaster RB, Kessler FC, Howard HH 2005 Thematic Cartography and
Geographic Visualization, Prentice Hall, Upper Saddle River NJ.

Fisher, W. D. 1958 "On grouping for maximum homogeneity", Journal of the American
Statistical Association, 53, 789-798
}
\seealso{
\code{\link{classIntervals}}
}
