% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_energy.R
\name{plot_energy}
\alias{plot_energy}
\title{plot_energy}
\usage{
plot_energy(pattern, col = NULL)
}
\arguments{
\item{pattern}{List with reconstructed patterns.}

\item{col}{Vector with colors. Must be as long as n_random.}
}
\description{
Plot energy of pattern reconstruction
}
\details{
The function plots the decrease of the energy over time, i.e. the iterations.
This can help to identify if enough max_runs where chosen for the reconstruction.
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern_homo(species_a, n_random = 3, max_runs = 1000)
plot_energy(pattern_recon)

marks_sub <- spatstat::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_pattern_marks(pattern_recon$randomized[[1]], marks_sub,
n_random = 1, max_runs = 1000)
plot_energy(marks_recon)
}

}
\seealso{
\code{\link{calculate_energy}} \cr
\code{\link{reconstruct_pattern_homo}} \cr
\code{\link{reconstruct_pattern_hetero}} \cr
\code{\link{reconstruct_pattern_cluster}} \cr
\code{\link{plot_randomized_pattern}}
}
