% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{ArgmaxId}
\alias{ArgmaxId}
\title{Calibrated parameter indices}
\usage{
ArgmaxId(stability = NULL, S = NULL)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}} or
\code{\link{GraphicalModel}}. If \code{stability=NULL}, \code{S} must be
provided.}

\item{S}{matrix of stability scores obtained with different combinations of
parameters where rows correspond to different values of the parameter
controlling the level of sparsity in the underlying feature selection
algorithm and columns correspond to different values of the threshold in
selection proportions. If \code{S=NULL}, argument \code{stability} must be
provided.}
}
\value{
A matrix of parameter indices. For multi-block graphical models, rows
  correspond to different blocks.
}
\description{
Extracts the indices of calibrated parameters with respect to the grids
provided in \code{Lambda} and \code{pi_list} in \code{stability}.
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateGraphical(pk = 20)

# Stability selection
stab <- GraphicalModel(xdata = simul$data)

# Extracting IDs of calibrated parameters
ids <- ArgmaxId(stab)
stab$Lambda[ids[1], 1]
stab$params$pi_list[ids[2]]

# Alternative formulation
ids2 <- ArgmaxId(S = stab$S_2d)

# Link with Argmax() function
args <- Argmax(stab)
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}}

Other calibration functions: 
\code{\link{Adjacency}()},
\code{\link{Argmax}()},
\code{\link{CalibrationPlot}()},
\code{\link{SelectedVariables}()},
\code{\link{SelectionProportions}()}
}
\concept{calibration functions}
