% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{Ensemble}
\alias{Ensemble}
\title{Ensemble model}
\usage{
Ensemble(stability, xdata, ydata)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}}.}

\item{xdata}{matrix of predictors with observations as rows and variables as
columns.}

\item{ydata}{optional vector or matrix of outcome(s). If \code{family} is set
to \code{"binomial"} or \code{"multinomial"}, \code{ydata} can be a vector
with character/numeric values or a factor.}
}
\value{
An object of class \code{ensemble_model}. A list with:
  \item{intercept}{a vector of refitted intercepts for the \code{K}
  calibrated models.} \item{beta}{a matrix of beta coefficients from the
  \code{K} calibrated models.} \item{models}{a list of \code{K} models that
  can be used for prediction. These models are of class \code{"lm"} if
  \code{family="gaussian"} or \code{"glm"} if
  \code{family="binomial"}.} \item{family}{type of regression, extracted from
  \code{stability}. Possible values are \code{"gaussian"} or
  \code{"binomial"}.}
}
\description{
Creates an ensemble predictive model from \code{\link{VariableSelection}}
outputs.
}
\examples{
\donttest{
# Linear regression
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, family = "gaussian")
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, family = "gaussian")
ensemble <- Ensemble(stability = stab, xdata = simul$xdata, ydata = simul$ydata)

# Logistic regression
set.seed(1)
simul <- SimulateRegression(n = 200, pk = 20, family = "binomial")
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, family = "binomial")
ensemble <- Ensemble(stability = stab, xdata = simul$xdata, ydata = simul$ydata)
}
}
\seealso{
Other ensemble model functions: 
\code{\link{EnsemblePredictions}()}
}
\concept{ensemble model functions}
