# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Computes the number of upper records of the cumulative sum of \code{x}
#'
#' @param x a vector of sample values
#' @return the number of upper records 
num_records_up <- function(x) {
    .Call('_sharpeRratio_num_records_up', PACKAGE = 'sharpeRratio', x)
}

#' Computes the number of lower records of the cumulative sum of \code{x}
#'
#' @param x a vector of sample values
#' @return the number of lower records 
num_records_down <- function(x) {
    .Call('_sharpeRratio_num_records_down', PACKAGE = 'sharpeRratio', x)
}

#' Computes the average difference between the number of upper and lower records of the cumulative sum of the sample values.
#'
#' @param x a vector of sample values
#' @param numPerm the number of random permutations (or shuffles) of the sample value order
#' @param q1 a real number for computing the lower confidence interval  
#' @param q2 a real number for computing the upper confidence interval  
#' @return a list \itemize{
#' \item mean the average difference of upper and lower records of the cumulative sum of \code{x}
#' \item q1 the q1 quantile of the difference
#' \item q1 the q2 quantile of the difference}
#' 
computeR0bar <- function(x, numPerm = 100L, q1 = 0.025, q2 = 0.975) {
    .Call('_sharpeRratio_computeR0bar', PACKAGE = 'sharpeRratio', x, numPerm, q1, q2)
}

