\name{aggregateColorPlot}
\alias{aggregateColorPlot}

\title{Plot aggregate soil color data}
\description{Generate a plot from summaries generated by aqp::aggregateColor().}
\usage{
aggregateColorPlot(x, print.label=TRUE, label.font = 1, 
label.cex = 0.65, buffer.pct = 0.02, print.n.hz=FALSE, 
rect.border='black', horizontal.borders=FALSE, 
horizontal.border.lwd=2, x.axis=TRUE, y.axis=TRUE,
...)
}

\arguments{
  \item{x}{a list, results from \code{aqp::aggregateColor()}}
  \item{print.label}{print Munsell color labels inside of rectangles, when they fit}
  \item{label.font}{font specification for color labels}
  \item{label.cex}{font size for color lables}
  \item{buffer.pct}{extra space between labels and color rectangles}
  \item{print.n.hz}{optionally print the number of horizons}
  \item{rect.border}{color for rectangle border}
  \item{horizontal.borders}{optionally add horizontal borders between bands of color}
  \item{horizontal.border.lwd}{line width for horizontal borders}
  \item{x.axis}{logical: add a scale and label to x-axis?}
  \item{y.axis}{logical: add group labels to y-axis?}
  \item{\dots}{additional arguments passed to plot}
}
\details{Tutorial at \url{http://ncss-tech.github.io/AQP/sharpshootR/aggregate-soil-color.html}.}

\author{D.E. Beaudette}

\examples{
\donttest{

if(requireNamespace("curl") &
   curl::has_internet() &
   require(aqp) &
   require(soilDB)) {
  
  data(loafercreek, package = 'soilDB')

# generalize horizon names using REGEX rules
n <- c('Oi', 'A', 'BA','Bt1','Bt2','Bt3','Cr','R')
p <- c('O', '^A$|Ad|Ap|AB','BA$|Bw', 
'Bt1$|^B$','^Bt$|^Bt2$','^Bt3|^Bt4|CBt$|BCt$|2Bt|2CB$|^C$','Cr','R')
loafercreek$genhz <- generalize.hz(loafercreek$hzname, n, p)

# remove non-matching generalized horizon names
loafercreek$genhz[loafercreek$genhz == 'not-used'] <- NA
loafercreek$genhz <- factor(loafercreek$genhz)

# aggregate color data, this function is from the `aqp` package
a <- aggregateColor(loafercreek, 'genhz')

# plot
par(mar=c(4,4,1,1))
aggregateColorPlot(a, print.n.hz = TRUE)
  
}



}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{hplots}
