% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailyWB.R
\name{dailyWB}
\alias{dailyWB}
\title{Simple Daily Water Balance}
\usage{
dailyWB(x, daily.data, id, MS.style = "default", S_0 = 0.5, M = 0, etmult = 1)
}
\arguments{
\item{x}{\code{data.frame}, required columns include:
\itemize{
\item \code{sat}: VWC at satiation
\item \code{fc}: VWC at field capacity
\item \code{pwp}: VWC at permanent wilting point
\item \code{thickness}: soil material thickness in cm
\item \code{a.ss}: recession coefficients for subsurface flow from saturated zone, should be > 0 (range: 0-1)
\item "id"
}}

\item{daily.data}{\code{data.frame}, required columns include:
\itemize{
\item \code{date}: \code{Date} class representation of dates
\item \code{PPT}: daily total, precipitation in mm
\item \code{PET}: daily total, potential ET in mm
}}

\item{id}{character, name of column in \code{x} that is used to identify records}

\item{MS.style}{moisture state classification style, see \code{\link{estimateSoilMoistureState}}}

\item{S_0}{fraction of water storage filled at time = 0 (range: 0-1)}

\item{M}{fraction of area covered by deep-rooted vegetation}

\item{etmult}{multiplier for PET}
}
\value{
a \code{data.frame}
}
\description{
Simple interface to the hydromad "leaky bucket" soil moisture model, with accommodation for typical inputs from common soil data and climate sources. Critical points along the water retention curve are specified using volumetric water content (VWC): satiation (saturation), field capacity (typically 1/3 bar suction), and permanent wilting point (typically 15 bar suction).
}
\references{
Farmer, D., M. Sivapalan, Farmer, D. (2003). Climate, soil and vegetation controls upon the variability of water balance in temperate and semiarid landscapes: downward approach to water balance analysis. Water Resources Research 39(2), p 1035.

Bai, Y., T. Wagener, P. Reed (2009). A top-down framework for watershed model evaluation and selection under uncertainty. Environmental Modelling and Software 24(8), pp. 901-916.
}
