% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value.R
\name{render_info_value}
\alias{render_info_value}
\title{Server render function for info value}
\usage{
render_info_value(expr, env = parent.frame(), quoted = FALSE,
  sep = " ", add_name = TRUE)
}
\arguments{
\item{expr}{value to render}

\item{env}{The environment in which to evaluate expr. Default parent.frame()}

\item{quoted}{Is expr a quoted expression (with quote())? This is useful if you want to save an
expression in a variable. Default FALSE}

\item{sep}{A separator passed to cat to be appended after each element.}

\item{add_name}{Should expression name be added. Default TRUE}
}
\value{
Shiny render function to be saved as an element of output.
}
\description{
Server render function for info value
}
\details{
If you want to use it with toggle_info(),
 you have to add outputOptions(output, [info value id], suspendWhenHidden = FALSE) to force
 rendering when the value is hidden.
}
\examples{
if(interactive()){
library(shiny)
library(shiny.info)

ui <- fluidPage(
  info_value("value_to_display")
)

server <- function(input, output, session) {
  test_reactive <- reactiveVal("some value")
  output$value_to_display <- render_info_value(expr = test_reactive())
  # next line is required to work with toggle_info()
  outputOptions(output, "value_to_display", suspendWhenHidden = FALSE)
}
}
}
