% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{form}
\alias{form}
\title{Create Semantic UI form tag}
\usage{
form(..., class = "")
}
\arguments{
\item{...}{Other arguments to be added as attributes of the
tag (e.g. style, class or childrens etc.)}

\item{class}{Additional classes to add to html tag.}
}
\description{
This creates a form tag using Semantic UI styles.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()){
  library(shiny)
  library(shiny.semantic)

  ui <- shinyUI(semanticPage(
    form(
      field(
        tags$label("Text"),
        text_input("text_ex", value = "", type = "text", placeholder = "Enter Text...")
      )
    ),
    # loading form
    form(class = "loading form",
         field(
           tags$label("Text"),
           text_input("text_ex", value = "", type = "text", placeholder = "Enter Text...")
         )),
    # size variations mini form
    form(class = "mini",
         field(
           tags$label("Text"),
           text_input("text_ex", value = "", type = "text", placeholder = "Enter Text...")
         )),
    # massive
    form(class = "massive",
         field(
           tags$label("Text"),
           text_input("text_ex", value = "", type = "text", placeholder = "Enter Text...")
         ))
  ))
  server <- shinyServer(function(input, output) {
  })

  shinyApp(ui, server)
}

}
