% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_discrete.R
\name{keep_na_input}
\alias{keep_na_input}
\alias{.keep_na_input}
\alias{.update_keep_na_input}
\title{Generate NA's filter selection GUI input}
\usage{
.keep_na_input(
  input_id,
  filter,
  cohort,
  msg_fun = function(x) glue::glue("Keep missing values ({x})")
)

.update_keep_na_input(
  session,
  input_id,
  filter,
  cohort,
  msg_fun = function(x) glue::glue("Keep missing values ({x})")
)
}
\arguments{
\item{input_id}{Id of the keep na input.}

\item{filter}{Filter object.}

\item{cohort}{Cohort object.}

\item{msg_fun}{Function taking number of missing values as an argument and
returning missing values label.}

\item{session}{Shiny session object.}
}
\value{
Nested list of `shiny.tag` objects storing html structure of the input,
or no value in case of usage 'update' method.
}
\description{
When used within filter's GUI input method, the component is responsible for
updating `keep_na` filter parameter.

Use `.update_keep_na_input` inside filter's GUI update method to update the
output based on the filter state.
}
\examples{
library(magrittr)
library(cohortBuilder)

librarian_source <- set_source(as.tblist(librarian))
coh <- cohort(
  librarian_source,
  filter(
    "range", id = "copies", name = "Copies", dataset = "books",
    variable = "copies", range = c(5, 12)
  )
) \%>\% run()
.keep_na_input("keep_na", coh$get_filter("1", "copies"), coh)

}
