% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snackbar.R
\name{showSnackbar}
\alias{showSnackbar}
\title{showSnackbar}
\usage{
showSnackbar(id, autoHideDuration = 3000)
}
\arguments{
\item{id}{A length 1 character vector.  A unique id for the snackbar.}

\item{autoHideDuration}{A length 1 numeric vector.  The amount of time in milliseconds to show the 
snackbar (e.g. \code{3000} is 3 seconds).  Set to NULL to keep snackbar open indefinitely.}
}
\description{
Server side function to show a snackbar.  This function should be called in the expression passed
to \code{shiny::observe()} or \code{shiny::observeEvent()}.
}
\examples{

## Only run examples in interacive R sessions
if (interactive()) {
  
  ui <- fluidPage(
    useShinyFeedback(),
    
    actionButton(
      "showSnackbarBtn",
      "Show Snackbar"
    ),
    
    snackbar(
      id = "mySnackbar",
      message = "Have a snack!"
    )
  )
  
  server <- function(input, output) {
    observeEvent(input$showSnackbarBtn, {
      showSnackbar("mySnackbar")
    })
  }
  
  shinyApp(ui, server)
}

}
