% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Messages.R
\name{f7Messages}
\alias{f7Messages}
\title{Create a Framework7 messages container}
\usage{
f7Messages(
  id,
  title = NULL,
  autoLayout = TRUE,
  newMessagesFirst = FALSE,
  scrollMessages = TRUE,
  scrollMessagesOnEdge = TRUE
)
}
\arguments{
\item{id}{Container id.}

\item{title}{Optional messages title.}

\item{autoLayout}{Enable Auto Layout to add all required additional classes
automatically based on passed conditions.}

\item{newMessagesFirst}{Enable if you want to use new messages on top,
instead of having them on bottom.}

\item{scrollMessages}{Enable/disable messages autoscrolling when adding new message.}

\item{scrollMessagesOnEdge}{If enabled then messages autoscrolling will happen only
when user is on top/bottom of the messages view.}
}
\description{
Create a Framework7 messages container
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shiny::shinyApp(
  ui = f7Page(
    title = "My app",
    init = f7Init(skin = "ios", theme = "light"),
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Messages",
        hairline = FALSE,
        shadow = TRUE
      ),
      toolbar = f7MessageBar(inputId = "mymessagebar", placeholder = "Message"),
      # main content
      f7Messages(id = "mymessages", title = "My message")

    )
  ),
  server = function(input, output, session) {
    observe({
      print(input[["mymessagebar-send"]])
      print(input$mymessages)
    })
    observeEvent(input[["mymessagebar-send"]], {
      f7AddMessages(
        id = "mymessages",
        list(
         f7Message(
          text = input$mymessagebar,
          name = "David",
          type = "sent",
          header = "Message Header",
          footer = "Message Footer",
          textHeader = "Text Header",
          textFooter = "text Footer",
          avatar = "https://cdn.framework7.io/placeholder/people-100x100-7.jpg"
         )
        )
      )
    })

    observe({
      invalidateLater(5000)
      names <- c("Victor", "John")
      name <- sample(names, 1)

      f7AddMessages(
        id = "mymessages",
        list(
         f7Message(
          text = "Some message",
          name = name,
          type = "received",
          avatar = "https://cdn.framework7.io/placeholder/people-100x100-9.jpg"
         )
        )
      )
    })

  }
 )
}
}
