% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Block.R
\name{f7Block}
\alias{f7Block}
\alias{f7BlockHeader}
\title{Framework7 block}
\usage{
f7Block(..., hairlines = TRUE, strong = FALSE, inset = FALSE, tablet = FALSE)

f7BlockHeader(text = NULL)
}
\arguments{
\item{...}{Block content. Also for \link{f7BlockHeader} and \link{f7BlockFooter}.}

\item{hairlines}{Whether to allow hairlines. TRUE by default.}

\item{strong}{Whether to put the text in bold. FALSE by default.}

\item{inset}{Whether to set block inset. FALSE by default. Works only if strong is TRUE.}

\item{tablet}{Whether to make block inset only on large screens. FALSE by default.}

\item{text}{Any text.}
}
\description{
\link{f7Block} creates a block container.

\link{f7BlockHeader} creates a header content for \link{f7Block}.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Blocks",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Block"),
     f7BlockTitle(title = "A large title", size = "large"),
    f7Block(
     f7BlockHeader(text = "Header"),
     "Here comes paragraph within content block.
     Donec et nulla auctor massa pharetra
     adipiscing ut sit amet sem. Suspendisse
     molestie velit vitae mattis tincidunt.
     Ut sit amet quam mollis, vulputate
     turpis vel, sagittis felis.",
     f7BlockFooter(text = "Footer")
    ),

    f7BlockTitle(title = "A medium title", size = "medium"),
    f7Block(
     strong = TRUE,
     f7BlockHeader(text = "Header"),
     "Here comes paragraph within content block.
     Donec et nulla auctor massa pharetra
     adipiscing ut sit amet sem. Suspendisse
     molestie velit vitae mattis tincidunt.
     Ut sit amet quam mollis, vulputate
     turpis vel, sagittis felis.",
     f7BlockFooter(text = "Footer")
    ),

    f7BlockTitle(title = "A normal title", size = NULL),
    f7Block(
     inset = TRUE,
     strong = TRUE,
     f7BlockHeader(text = "Header"),
     "Here comes paragraph within content block.
     Donec et nulla auctor massa pharetra
     adipiscing ut sit amet sem. Suspendisse
     molestie velit vitae mattis tincidunt.
     Ut sit amet quam mollis, vulputate
     turpis vel, sagittis felis.",
     f7BlockFooter(text = "Footer")
    ),
    f7Block(
     tablet = TRUE,
     strong = TRUE,
     f7BlockHeader(text = "Header"),
     "Here comes paragraph within content block.
     Donec et nulla auctor massa pharetra
     adipiscing ut sit amet sem. Suspendisse
     molestie velit vitae mattis tincidunt.
     Ut sit amet quam mollis, vulputate
     turpis vel, sagittis felis.",
     f7BlockFooter(text = "Footer")
    ),
    f7Block(
     inset = TRUE,
     strong = TRUE,
     hairlines = FALSE,
     f7BlockHeader(text = "Header"),
     "Here comes paragraph within content block.
     Donec et nulla auctor massa pharetra
     adipiscing ut sit amet sem. Suspendisse
     molestie velit vitae mattis tincidunt.
     Ut sit amet quam mollis, vulputate
     turpis vel, sagittis felis.",
     f7BlockFooter(text = "Footer")
    )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
