% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Icon.R
\name{f7Icon}
\alias{f7Icon}
\title{Framework7 icons}
\usage{
f7Icon(..., lib = NULL, color = NULL, style = NULL, old = NULL)
}
\arguments{
\item{...}{Icon name and \link{f7Badge}.}

\item{lib}{Library to use: NULL, "ios" or "md". Leave \code{NULL} by default. Specify, md or ios
if you want to hide/show icons on specific devices.}

\item{color}{Icon color, if any.}

\item{style}{CSS styles to be applied on icon, for example
use \code{font-size: 56px;} to have a bigger icon.}

\item{old}{Deprecated. This was to handle old and new icons but shinyMobile only uses
new icons from now. This parameter will be removed in a future release.}
}
\description{
Use Framework7 icons in shiny applications,
 see complete list of icons here : \url{https://framework7.io/icons/}.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Icons",
    f7SingleLayout(
     navbar = f7Navbar(title = "icons"),
     f7List(
      f7ListItem(
        title = tagList(
         f7Icon("envelope")
        )
      ),
      f7ListItem(
        title = tagList(
         f7Icon("envelope_fill", color = "green")
        )
      ),
      f7ListItem(
        title = f7Icon("home", f7Badge("1", color = "red"))
      ),
      f7ListItem(
        title = f7Icon("email_fill", lib = "md"),
        "This will not appear since only for material design"
      )
     )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
