% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typography.R
\name{f7Margin}
\alias{f7Margin}
\title{Framework7 margin utility}
\usage{
f7Margin(tag, side = NULL)
}
\arguments{
\item{tag}{Tag to apply the margin.}

\item{side}{margin side: "left", "right", "top", "bottom",
"vertical" (top and bottom), "horizontal" (left and right).
Leave NULL to apply on all sides.}
}
\description{
\link{f7Margin} adds a margin to the given tag.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 cardTag <- f7Card(
  title = "Card header",
  "This is a simple card with plain text,
  but cards can also contain their own header,
  footer, list view, image, or any other element.",
  footer = tagList(
    f7Button(color = "blue", label = "My button", href = "https://www.google.com"),
    f7Badge("Badge", color = "green")
  )
 )

 shinyApp(
   ui = f7Page(
    title = "Margins",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Margin"),
     f7Margin(cardTag),
     cardTag
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
