% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Card.R
\name{f7Card}
\alias{f7Card}
\alias{f7SocialCard}
\alias{f7ExpandableCard}
\alias{updateF7Card}
\title{Framework7 card}
\usage{
f7Card(
  ...,
  image = NULL,
  title = NULL,
  footer = NULL,
  outline = FALSE,
  height = NULL
)

f7SocialCard(..., image = NULL, author = NULL, date = NULL, footer = NULL)

f7ExpandableCard(
  ...,
  id = NULL,
  title = NULL,
  subtitle = NULL,
  color = NULL,
  image = NULL,
  fullBackground = FALSE
)

updateF7Card(id, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{...}{Card content.}

\item{image}{Card background image url. Tje JPG format is prefered. Not compatible
with the color argument.}

\item{title}{Card title.}

\item{footer}{Footer content, if any. Must be wrapped in a tagList.}

\item{outline}{Outline style. FALSE by default.}

\item{height}{Card height. NULL by default.}

\item{author}{Author.}

\item{date}{Date.}

\item{id}{Card id.}

\item{subtitle}{Card subtitle.}

\item{color}{Card background color. See \url{https://framework7.io/docs/cards.html}.
Not compatible with the img argument.}

\item{fullBackground}{Whether the image should cover the entire card.}

\item{session}{Shiny session object.}
}
\description{
\code{f7Card} creates a simple card container.

\code{f7SocialCard} is a special card for social content.

\code{f7ExpandableCard} is a card that can expand. Ideal for a
gallery.

\code{updateF7Card} maximizes an \link{f7ExpandableCard} on the client.
}
\note{
For \link{f7ExpandableCard}, image and color are not compatible. Choose one of them.
}
\examples{
# Simple card
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Cards",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Card"),
     f7Card("This is a simple card with plain text,
    but cards can also contain their own header,
    footer, list view, image, or any other element."),
    f7Card(
     title = "Card header",
     "This is a simple card with plain text,
     but cards can also contain their own header,
     footer, list view, image, or any other element.",
     footer = tagList(
      f7Button(color = "blue", label = "My button"),
      f7Badge("Badge", color = "green")
     )
    ),
    f7Card(
     title = "Card header",
     image = "https://loremflickr.com/320/240",
     "This is a simple card with plain text,
     but cards can also contain their own header,
     footer, list view, image, or any other element.",
     footer = tagList(
      f7Button(color = "blue", label = "My button"),
      f7Badge("Badge", color = "green")
     )
    )
    )
  ),
  server = function(input, output) {}
 )
}

# Social card
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Social Card",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7SocialCard"),
     f7SocialCard(
     image = "https://loremflickr.com/g/320/240/paris",
     author = "John Doe",
     date = "Monday at 3:47 PM",
     "What a nice photo i took yesterday!",
     img(src = "https://loremflickr.com/g/320/240/paris", width = "100\%"),
     footer = tagList(
      f7Badge("1", color = "yellow"),
      f7Badge("2", color = "green"),
      f7Badge("3", color = "blue")
     )
    )
    )
  ),
  server = function(input, output) {}
 )
}

# Expandable card
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "Expandable Cards",
    f7SingleLayout(
      navbar = f7Navbar(
       title = "Expandable Cards",
       hairline = FALSE,
       shadow = TRUE
      ),
      f7ExpandableCard(
       id = "card1",
       title = "Expandable Card 1",
       color = "blue",
       subtitle = "Click on me pleaaaaase",
       "Framework7 - is a free and open source HTML mobile framework
       to develop hybrid mobile apps or web apps with iOS or Android
       native look and feel. It is also an indispensable prototyping apps tool
       to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card2",
       title = "Expandable Card 2",
       color = "green",
       "Framework7 - is a free and open source HTML mobile framework
       to develop hybrid mobile apps or web apps with iOS or Android
       native look and feel. It is also an indispensable prototyping apps tool
       to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card3",
       title = "Expandable Card 3",
       image = "https://i.pinimg.com/originals/73/38/6e/73386e0513d4c02a4fbb814cadfba655.jpg",
       "Framework7 - is a free and open source HTML mobile framework
        to develop hybrid mobile apps or web apps with iOS or Android
        native look and feel. It is also an indispensable prototyping apps tool
        to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card4",
       title = "Expandable Card 4",
       fullBackground = TRUE,
       image = "https://i.ytimg.com/vi/8q_kmxwK5Rg/maxresdefault.jpg",
       "Framework7 - is a free and open source HTML mobile framework
              to develop hybrid mobile apps or web apps with iOS or Android
              native look and feel. It is also an indispensable prototyping apps tool
              to show working app prototype as soon as possible in case you need to."
      )
    )
  ),
  server = function(input, output) {}
 )
}

# Update expandable card
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "Expandable Cards",
     f7SingleLayout(
       navbar = f7Navbar(
         title = "Expandable Cards",
         hairline = FALSE,
         shadow = TRUE
       ),
       f7ExpandableCard(
         id = "card1",
         title = "Expandable Card 1",
         image = "http://i.pinimg.com/originals/73/38/6e/73386e0513d4c02a4fbb814cadfba655.jpg",
         "Framework7 - is a free and open source HTML mobile framework
         to develop hybrid mobile apps or web apps with iOS or Android
         native look and feel. It is also an indispensable prototyping apps tool
         to show working app prototype as soon as possible in case you need to."
       ),

       hr(),
       f7BlockTitle(title = "Click below to expand the card!") \%>\% f7Align(side = "center"),
       f7Button(inputId = "go", label = "Go"),
       br(),
       f7ExpandableCard(
         id = "card2",
         title = "Expandable Card 2",
         fullBackground = TRUE,
         image = "http://i.ytimg.com/vi/8q_kmxwK5Rg/maxresdefault.jpg",
         "Framework7 - is a free and open source HTML mobile framework
               to develop hybrid mobile apps or web apps with iOS or Android
               native look and feel. It is also an indispensable prototyping apps tool
               to show working app prototype as soon as possible in case you need to."
       )
     )
   ),
   server = function(input, output, session) {

     observeEvent(input$go, {
       updateF7Card(id = "card2")
     })

     observe({
       list(
         print(input$card1),
         print(input$card2)
       )
     })
   }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
