% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw-dropdown.R
\name{dropdown}
\alias{dropdown}
\title{Dropdown}
\usage{
dropdown(..., style = "default", status = "default", size = "md",
  icon = NULL, label = NULL, tooltip = FALSE, right = FALSE,
  up = FALSE, width = NULL, animate = FALSE, inputId = NULL)
}
\arguments{
\item{...}{List of tag to be displayed into the dropdown menu.}

\item{style}{Character. if \code{default} use Bootstrap button (like an \code{actionButton}), else use an
\code{actionBttn}, see argument \code{style} for possible values.}

\item{status}{Add a class to the buttons, you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.
Or use an arbitrary strings to add a custom class, e.g. : with \code{status = 'myClass'}, buttons will have class \code{btn-myClass}.}

\item{size}{Size of the button : default, lg, sm, xs.}

\item{icon}{An icon to appear on the button.}

\item{label}{Label to appear on the button. If circle = TRUE and tooltip = TRUE, label is used in tooltip.}

\item{tooltip}{Put a tooltip on the button, you can customize tooltip with \code{tooltipOptions}.}

\item{right}{Logical. The dropdown menu starts on the right.}

\item{up}{Logical. Display the dropdown menu above.}

\item{width}{Width of the dropdown menu content.}

\item{animate}{Add animation on the dropdown, can be logical or result of \code{animateOptions}.}

\item{inputId}{Optional, id for the button, the button act like an \code{actionButton},
and you can use the id to toggle the dropdown menu server-side.}
}
\description{
Create a dropdown menu
}
\details{
This function is similar to \code{dropdownButton} but don't use Boostrap, so you can put \code{pickerInput} in it.
Moreover you can add animations on the appearance / disappearance of the dropdown with animate.css.
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  tags$h2("pickerInput in dropdown"),
  br(),
  dropdown(

    tags$h3("List of Input"),

    pickerInput(inputId = 'xcol2',
                label = 'X Variable',
                choices = names(iris),
                options = list(`style` = "btn-info")),

    pickerInput(inputId = 'ycol2',
                label = 'Y Variable',
                choices = names(iris),
                selected = names(iris)[[2]],
                options = list(`style` = "btn-warning")),

    sliderInput(inputId = 'clusters2',
                label = 'Cluster count',
                value = 3,
                min = 1, max = 9),

    style = "unite", icon = icon("gear"),
    status = "danger", width = "300px",
    animate = animateOptions(
      enter = animations$fading_entrances$fadeInLeftBig,
      exit = animations$fading_exits$fadeOutRightBig
    )
  ),

  plotOutput(outputId = 'plot2')
)

server <- function(input, output, session) {

  selectedData2 <- reactive({
    iris[, c(input$xcol2, input$ycol2)]
  })

  clusters2 <- reactive({
    kmeans(selectedData2(), input$clusters2)
  })

  output$plot2 <- renderPlot({
    palette(c("#E41A1C", "#377EB8", "#4DAF4A",
              "#984EA3", "#FF7F00", "#FFFF33",
              "#A65628", "#F781BF", "#999999"))

    par(mar = c(5.1, 4.1, 0, 1))
    plot(selectedData2(),
         col = clusters2()$cluster,
         pch = 20, cex = 3)
    points(clusters2()$centers, pch = 4, cex = 4, lwd = 4)
  })

}

shinyApp(ui = ui, server = server)

}
}
}
\seealso{
\code{\link{animateOptions}} for animation, \code{\link{tooltipOptions}} for tooltip and
\code{\link{actionBttn}} for the button.
}
