% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stati-card.R
\name{stati-card}
\alias{stati-card}
\alias{statiCard}
\alias{updateStatiCard}
\title{Minimal statistic cards}
\usage{
statiCard(
  value,
  subtitle,
  icon = NULL,
  left = FALSE,
  color = "steelblue",
  background = "white",
  animate = FALSE,
  duration = 2000,
  id = NULL
)

updateStatiCard(
  id,
  value,
  duration = 2000,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{value}{Value to display.}

\item{subtitle}{A subtitle to describe the value.}

\item{icon}{An optional icon created with \code{icon()}.}

\item{left}{Display value and subtitle to the right.}

\item{color}{Text color.}

\item{background}{Background color.}

\item{animate}{Add an animation when value is displayed.}

\item{duration}{Duration of animation.}

\item{id}{An id that can be used to update the card server-side.}

\item{session}{Shiny session.}
}
\value{
A UI definition.
}
\description{
Minimal statistic cards
}
\note{
Based on work by Dastanbek and ArielDavid on codepen.io
}
\examples{
library(shiny)
library(shinyWidgets)


ui <- fluidPage(

  tags$h2("Stati Card"),

  fluidRow(
    column(
      width = 3,
      statiCard(12, "Subtitle", icon("home")),
      statiCard(
        93, "Animated card", icon("users"),
        background = "deepskyblue",
        color = "white",
        animate = TRUE,
        id = "card1"
      ),
      actionButton("update1", "Update card above server-side"),
      statiCard(
        93, "No animation", icon("users"),
        background = "deepskyblue",
        color = "white",
        id = "card2"
      ),
      actionButton("update2", "Update card above server-side")
    ),
    column(
      width = 3,
      statiCard("$123,456", "Total spend", icon("rocket"), left = TRUE, animate = TRUE),
      tags$br(),
      actionButton("show", "Show card (rendered server-side)"),
      uiOutput(outputId = "card")
    ),
    column(
      width = 3,
      statiCard(12, "No animation", icon("home"), color = "firebrick")
    ),
    column(
      width = 3,
      statiCard(
        "123456 something very very long",
        "Long value text",
        icon = NULL,
        left = TRUE,
        background = "steelblue",
        color = "white"
      ),
      statiCard(
        "123456 something very very long",
        "Long value text with icon",
        icon = icon("tachometer"),
        left = TRUE
      ),
      statiCard(
        "123456 something very very long",
        "Long value text with icon right",
        icon = icon("tasks")
      )
    )
  )

)


server <- function(input, output, session) {

  observeEvent(input$update1, {
    updateStatiCard(
      id = "card1",
      value = sample.int(200, 1)
    )
  })

  observeEvent(input$update2, {
    updateStatiCard(
      id = "card2",
      value = sample.int(200, 1)
    )
  })

  output$card <- renderUI({
    req(input$show)
    statiCard(
      paste0(format(sample.int(1e6, 1), big.mark = " "), "â‚¬"),
      "Total spend",
      icon("shopping-cart"),
      left = TRUE,
      animate = TRUE
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
