% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw-dropdown.R
\name{dropdown}
\alias{dropdown}
\title{Dropdown}
\usage{
dropdown(
  ...,
  style = "default",
  status = "default",
  size = "md",
  icon = NULL,
  label = NULL,
  tooltip = FALSE,
  right = FALSE,
  up = FALSE,
  width = NULL,
  animate = FALSE,
  inputId = NULL,
  block = FALSE,
  no_outline = TRUE
)
}
\arguments{
\item{...}{List of tag to be displayed into the dropdown menu.}

\item{style}{Style of the button, to choose between \code{simple}, \code{bordered},
\code{minimal}, \code{stretch}, \code{jelly}, \code{gradient}, \code{fill},
\code{material-circle}, \code{material-flat}, \code{pill}, \code{float}, \code{unite}.}

\item{status}{Color of the button, see \code{\link[=actionBttn]{actionBttn()}}.}

\item{size}{Size of the button : \code{xs},\code{sm}, \code{md}, \code{lg}.}

\item{icon}{An optional icon to appear on the button.}

\item{label}{The contents of the button, usually a text label.}

\item{tooltip}{Put a tooltip on the button, you can customize tooltip with \code{\link[=tooltipOptions]{tooltipOptions()}}.}

\item{right}{Logical. The dropdown menu starts on the right.}

\item{up}{Logical. Display the dropdown menu above.}

\item{width}{Width of the dropdown menu content.}

\item{animate}{Add animation on the dropdown, can be logical or result of \code{\link[=animateOptions]{animateOptions()}}.}

\item{inputId}{Optional, id for the button, the button act like an \code{actionButton},
and you can use the id to toggle the dropdown menu server-side.}

\item{block}{Logical, full width button.}

\item{no_outline}{Logical, don't show outline when navigating with
keyboard/interact using mouse or touch.}
}
\description{
Create a dropdown menu
}
\details{
This function is similar to \code{\link[=dropdownButton]{dropdownButton()}} but don't use Bootstrap, so you can use \code{\link[=pickerInput]{pickerInput()}} in it.
Moreover you can add animations on the appearance / disappearance of the dropdown with animate.css.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library("shiny")
library("shinyWidgets")

ui <- fluidPage(
  tags$h2("pickerInput in dropdown"),
  br(),
  dropdown(

    tags$h3("List of Input"),

    pickerInput(inputId = 'xcol2',
                label = 'X Variable',
                choices = names(iris),
                options = list(`style` = "btn-info")),

    pickerInput(inputId = 'ycol2',
                label = 'Y Variable',
                choices = names(iris),
                selected = names(iris)[[2]],
                options = list(`style` = "btn-warning")),

    sliderInput(inputId = 'clusters2',
                label = 'Cluster count',
                value = 3,
                min = 1, max = 9),

    style = "unite", icon = icon("gear"),
    status = "danger", width = "300px",
    animate = animateOptions(
      enter = animations$fading_entrances$fadeInLeftBig,
      exit = animations$fading_exits$fadeOutRightBig
    )
  ),

  plotOutput(outputId = 'plot2')
)

server <- function(input, output, session) {

  selectedData2 <- reactive({
    iris[, c(input$xcol2, input$ycol2)]
  })

  clusters2 <- reactive({
    kmeans(selectedData2(), input$clusters2)
  })

  output$plot2 <- renderPlot({
    palette(c("#E41A1C", "#377EB8", "#4DAF4A",
              "#984EA3", "#FF7F00", "#FFFF33",
              "#A65628", "#F781BF", "#999999"))

    par(mar = c(5.1, 4.1, 0, 1))
    plot(selectedData2(),
         col = clusters2()$cluster,
         pch = 20, cex = 3)
    points(clusters2()$centers, pch = 4, cex = 4, lwd = 4)
  })

}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link[=dropMenu]{dropMenu()}} for a more robust alternative.
}
